%define _unpackaged_files_terminate_build 1

%define rname kcm-howdy

Name: %rname
Version: 6.0.2
Release: alt1

Summary: KDE Workspace 6 Howdy configuration module
License: GPLv3+
Group: Graphical desktop/KDE
Url: https://gitlab.com/golubevan/kcm-howdy

Provides: kde5-kcm-howdy = %EVR
Obsoletes: kde5-kcm-howdy < %EVR

# howdy doesn't support ppc64le
ExcludeArch: ppc64le

Source: %name-%version.tar

%K6init

BuildRequires(pre): rpm-build-kf6
BuildRequires: cmake
BuildRequires: extra-cmake-modules
BuildRequires: gcc-c++
BuildRequires: kf6-kcoreaddons-devel
BuildRequires: kf6-kpackage-devel
BuildRequires: kf6-kcmutils-devel
BuildRequires: kf6-kdeclarative-devel
BuildRequires: kf6-ki18n-devel
BuildRequires: qt6-multimedia-devel
BuildRequires: libopencv-devel
BuildRequires: dlib-devel
BuildRequires: libsystemd-devel

# needed for dlib
BuildRequires: libgif-devel
BuildRequires: libsqlite3-devel
BuildRequires: libavdevice-devel
BuildRequires: libavfilter-devel
BuildRequires: libswresample-devel
BuildRequires: libswscale-devel
BuildRequires: liblapack-devel
BuildRequires: libopenblas-devel

Requires: howdy

%define module_config_file %_xdgconfigdir/%rname/%rname.ini

%description
KDE Workspace 6 Howdy configuration module

%prep
%setup

%build
%K6build \
    -DUSE_AUTO_VECTOR=OFF \
    -DMODULE_CONFIG_FILE="%module_config_file"

%install
%K6install
%K6install_move data kcm_howdy kpackage

%find_lang --with-kde --append --output=%name.lang kcm_howdy

%post
# Get the minimum UID from login.defs
UID_MIN=$(awk '/^UID_MIN/ {print $2}' /etc/login.defs 2>/dev/null)
sed -i "s/^minimum-uid=.*/minimum-uid=$UID_MIN/" %module_config_file

%files -f %name.lang
%config %module_config_file
%_K6xdgapp/kcm_howdy.desktop
%_K6plug/plasma/kcms/systemsettings/kcm_howdy.so
%_K6data/icons/hicolor/scalable/apps/howdy.svg

# auth helper
%_K6exec/kauth/kcm-howdy-auth-helper
%_datadir/dbus-1/system.d/org.kde.kcontrol.kcmhowdy.conf
%_datadir/polkit-1/actions/org.kde.kcontrol.kcmhowdy.policy
%_K6dbus_sys_srv/org.kde.kcontrol.kcmhowdy.service

%changelog
