%define soversion 5

Name: json-c
Version: 0.18
Release: alt1

Summary: JSON implementation in C
License: MIT
Group: System/Libraries
Url: https://github.com/json-c/json-c/wiki

Source: %name-%version.tar
# git://github.com/json-c/json-c.git

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake ctest

%description
JSON-C implements a reference counting object model that allows you to
easily construct JSON objects in C, output them as JSON formatted
strings and parse JSON formatted strings back into the C representation
of JSON objects.

%package -n lib%name%soversion
Summary: JSON shared library
Group: System/Libraries
Conflicts: filesystem < 3

%description -n lib%name%soversion
JSON-C implements a reference counting object model that allows you to
easily construct JSON objects in C, output them as JSON formatted
strings and parse JSON formatted strings back into the C representation
of JSON objects.

This package contains shared JSON-C library

%package -n lib%name-devel
Summary: header files for libjson
Group: Development/C
Requires: lib%name%soversion = %version-%release

%description -n lib%name-devel
JSON-C implements a reference counting object model that allows you to
easily construct JSON objects in C, output them as JSON formatted
strings and parse JSON formatted strings back into the C representation
of JSON objects.

This package contains development part of JSON-C

%prep
%setup

%build
%add_optflags %(getconf LFS_CFLAGS)
%cmake \
  -DBUILD_STATIC_LIBS:BOOL=OFF \
  -DCMAKE_BUILD_TYPE:STRING=RelWithDebInfo \
  -DCMAKE_C_FLAGS_RELEASE:STRING="" \
  -DDISABLE_BSYMBOLIC:BOOL=OFF \
  -DDISABLE_WERROR:BOOL=OFF \
  -DENABLE_RDRAND:BOOL=OFF \
  -DENABLE_THREADING:BOOL=ON

%cmake_build

%install
%cmake_install

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%ctest

%files -n lib%name%soversion
%_libdir/*.so.%{soversion}*

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*.pc
%_libdir/cmake/%name

%changelog
