%define pre _20071021

Name: jpicedt
Version: 1.4.1.03
Release: alt4_jpp6

Summary: Interactive picture editor for LaTeX and PSTricks.
License: GPL
Group: Development/Java
Url: http://jpicedt.sourceforge.net
Packager: Igor Vlasenko <viy@altlinux.org>

#Source: %name-src-%version%pre.jar
Source: %{name}.tar
Patch: jpicedt_1_4_1_03_20071021-unixhome.patch
Patch1: jpicedt_1_4_1_03_20071021-jar-include-help.patch

# Common dependencies
BuildPreReq: /proc rpm-build-java
BuildRequires: java-devel-default jpackage-utils ant junit unzip
Requires: java

# pkg deps
BuildRequires: bsh
Requires: bsh

BuildArch: noarch

%description
jPicEdt can generate LaTeX, eepic and PsTricks code from a user-friendly graphical interface. 
jPicEdt can parse LaTeX files that include a \begin{picture}...\end{picture} (or \begin{pspicture}...\end{pspicture}) block, and is able to interpret a great deal of commands, either LaTeX-, PsTricks- or eepic-compliant (this allows in particular to load files generated by GnuPlot with a gset term pstricks command).
jPicEdt is written in JAVA. As a result, it can run on any platform where a JVM (Java Virtual Machine) is installed (nearly every Unix flavors, plus Window 9x/2000/XP and MacOS, at least...)

%package javadoc
Summary: Javadoc for %name
Group: Development/Documentation
#Requires: java-common

%description javadoc
Javadoc for %name.

%package manual
Summary: Manual for %name
Group: Documentation

%description manual
Documentation for %name

%prep
%setup -q -c -n %name-%version
# remove all binary libs
find . -name "*.jar" -exec rm -f {} \;
find . -name "*.zip" -exec rm -f {} \;
find . -name "*.class" -exec rm -f {} \;

%patch -p1
%patch1 -p1

%build
export LANG=en_US.ISO8859-1
export CLASSPATH=$(build-classpath junit bsh)
%ant  -Dant.build.javac.source=1.6 -Dant.build.javac.target=1.6 \
	-Dbuild.sysclasspath=only \
	all
#	dist

%install
## jars
%__install -d -m 755 %buildroot%_javadir
%__install -m 644 dist/lib/%name.jar %buildroot%_javadir/%name-%version.jar
ln -s %name-%version.jar %buildroot%_javadir/%name.jar

# javadoc
%__install -d -m 755 %buildroot%_javadocdir/%name-%version
ln -s %name-%version %buildroot%_javadocdir/%name
cp -pr api-doc/* %buildroot%_javadocdir/%name-%version

# datadir
%__install -d -m 755 %buildroot%_datadir/%name
pushd dist
rm -rf add-ons/windows add-ons/unix/texshop_osx
rm -rf api-doc
rm -rf installer lib
# tetex dir rename
mv add-ons/unix/tetex add-ons/
rmdir add-ons/unix
subst s,/unix/tetex,/tetex, add-ons/tetex/configTeTeX.properties
# end 
mv add-ons help-files lang macros fragments %buildroot%_datadir/%name/
popd
chmod 755 %buildroot%_datadir/%name/add-ons/tetex/*.sh

cat > jpicedt.sh <<'EOF'
#!/bin/sh
java -cp `build-classpath jpicedt bsh2` jpicedt.JPicEdt
EOF
install -m755 -D jpicedt.sh %buildroot%_bindir/jpicedt


%files
#doc README.SRC
%doc jpicedt/{CHANGES,TODO}.txt
%doc dist/readme.html dist/quickstart.html
%_bindir/*
%_datadir/%name/
%_javadir/*.jar

%files javadoc
%doc %_javadocdir/%{name}*

#%files manual
#%doc dist/docs/*

%changelog
