Group: Development/Java
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-java
# END SourceDeps(oneline)
BuildRequires: /proc rpm-build-java
BuildRequires: jpackage-default
%define fedora 34
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# The gaxis module requires axis version 1.x
%if %{?fedora}%{!?fedora:0} >= 28 || %{?rhel}%{!?rhel:0} >= 7
%define gaxismodule 0
%else
%global gaxismodule 1
%endif

# The tomcat module is not compatible with tomcat 8.5 or later
%if %{?fedora}%{!?fedora:0} >= 28 || %{?rhel}%{!?rhel:0} >= 8
%define tomcatmodule 0
%else
%global tomcatmodule 1
%endif

Name:		jglobus
Version:	2.1.0
Release:	alt2_27jpp11
Summary:	Globus Java client libraries

#		Everything is Apache 2.0 except for one file that is MIT:
#		ssl-proxies/src/main/java/org/globus/tools/GridCertRequest.java
License:	ASL 2.0 and MIT
URL:		http://github.com/%{name}/
Source0:	http://github.com/%{name}/JGlobus/archive/JGlobus-Release-%{version}.tar.gz
#		DERObjectIdentifier is obsolete
#		https://github.com/jglobus/JGlobus/pull/149
Patch0:		%{name}-DERObjectIdentifier-is-obsolete.patch
#		Don't force SSLv3 in myproxy, allow TLS
#		Backport from git (trunk)
Patch1:		%{name}-dont-force-SSLv3.patch
#		Relax proxy validation to be RFC-3820 compliant
#		https://github.com/jglobus/JGlobus/issues/160
#		https://github.com/jglobus/JGlobus/pull/165
Patch2:		%{name}-key-usage.patch
#		Fix javadoc
#		https://github.com/jglobus/JGlobus/pull/162
Patch3:		%{name}-javadoc.patch
#		Do not accumulate matches in
#		GlobusPathMatchingResourcePatternResolver
#		https://github.com/jglobus/JGlobus/pull/157
Patch4:		%{name}-do-not-accumulate-matches-in-GlobusPathMatchingResou.patch
#		Compatibility with clients that request minimum TLS version 1.2
#		https://github.com/jglobus/JGlobus/pull/166
Patch5:		%{name}-do-not-force-SSLv3-TLSv1-allow-TLSv1.1-TLSv1.2.patch
#		Remove synchronization on CRL in CRLChecker
#		Drop workaround for race condition in BouncyCastle < 1.46
#		Reduced lock contention leads to higher request throughput
#		Backport from git (trunk and 2.1 branch)
Patch6:		%{name}-remove-synchronization-on-CRL-in-CRLChecker.patch
#		Fix "no key" error for PKCS#8 encoded keys
#		https://github.com/jglobus/JGlobus/issues/118
#		https://github.com/jglobus/JGlobus/issues/146
#		https://github.com/jglobus/JGlobus/pull/164
Patch7:		%{name}-support-PKCS8-key-format.patch
#		Only allow TLSv1 and TLSv1.2 (not TLSv1.1)
#		https://github.com/jglobus/JGlobus/pull/166
Patch8:		%{name}-only-allow-TLSv1-and-TLSv1.2-not-TLSv1.1.patch
#		Remove unused FORCE_SSLV3_AND_CONSTRAIN_CIPHERSUITES_FOR_GRAM
#		https://github.com/jglobus/JGlobus/pull/166
Patch9:		%{name}-remove-unused-FORCE_SSLV3_AND_CONSTRAIN_CIPHERSUITES.patch
#		Adapt to changes in bouncycastle 1.61
#		https://github.com/jglobus/JGlobus/pull/168
Patch10:	%{name}-adapt-to-changes-in-PrivateKeyInfo-class.patch
#		Update source and target for JDK 11
#		Add maven-javadoc-plugin configuration for JDK 11
Patch11:	%{name}-java-version.patch
#		DERInteger is obsolete
#		https://github.com/jglobus/JGlobus/pull/177
Patch12:	%{name}-DERInteger-is-obsolete.patch
#		DEROutputStream is private
#		https://github.com/jglobus/JGlobus/pull/177
Patch13:	%{name}-DEROutputStream-is-private.patch
#		ASN1OutputStream constructor is private - use create() method
#		https://github.com/jglobus/JGlobus/pull/183
Patch14:	%{name}-constructor-not-public.patch

BuildArch:	noarch

BuildRequires:	maven-local
%if %{gaxismodule}
BuildRequires:	mvn(axis:axis)
BuildRequires:	mvn(axis:axis-jaxrpc)
BuildRequires:	mvn(commons-httpclient:commons-httpclient)
BuildRequires:	mvn(javax.servlet:servlet-api)
%endif
BuildRequires:	mvn(commons-codec:commons-codec)
BuildRequires:	mvn(commons-io:commons-io)
BuildRequires:	mvn(commons-logging:commons-logging)
BuildRequires:	mvn(junit:junit)
BuildRequires:	mvn(log4j:log4j)
BuildRequires:	mvn(org.apache.httpcomponents:httpclient)
BuildRequires:	mvn(org.apache.maven.plugins:maven-compiler-plugin)
BuildRequires:	mvn(org.apache.maven.plugins:maven-surefire-plugin)
%if %{tomcatmodule}
BuildRequires:	mvn(org.apache.tomcat:tomcat-catalina)
BuildRequires:	mvn(org.apache.tomcat:tomcat-coyote)
%endif
BuildRequires:	mvn(org.bouncycastle:bcprov-jdk15on)
Source44: import.info

%description
%{name} is a collection of Java client libraries for Globus Toolkit security,
GRAM, GridFTP and MyProxy.

%package parent
Group: Development/Java
Summary:	Globus Java - parent pom file
License:	ASL 2.0

%description parent
Globus Java libraries parent maven pom file

%package ssl-proxies
Group: Development/Java
Summary:	Globus Java - SSL and proxy certificate support
License:	ASL 2.0 and MIT
%if ! %{gaxismodule}
Obsoletes:	%{name}-axisg < %{version}-%{release}
%endif
%if ! %{tomcatmodule}
Obsoletes:	%{name}-ssl-proxies-tomcat < %{version}-%{release}
%endif

%description ssl-proxies
Globus Java library with SSL and proxy certificate support

%package jsse
Group: Development/Java
Summary:	Globus Java - SSL support
License:	ASL 2.0
Requires:	%{name}-ssl-proxies = %{version}-%{release}

%description jsse
Globus Java library with SSL support

%package gss
Group: Development/Java
Summary:	Globus Java - GSS-API implementation for SSL with proxies
License:	ASL 2.0
Requires:	%{name}-jsse = %{version}-%{release}

%description gss
Globus Java GSS-API implementation for SSL with proxies

%package gram
Group: Development/Java
Summary:	Globus Java - Grid Resource Allocation and Management (GRAM)
License:	ASL 2.0
Requires:	%{name}-gss = %{version}-%{release}

%description gram
Globus Java library with GRAM support

%package gridftp
Group: Development/Java
Summary:	Globus Java - GridFTP
License:	ASL 2.0
Requires:	%{name}-gss = %{version}-%{release}

%description gridftp
Globus Java library with GridFTP support

%if %{tomcatmodule}
%package ssl-proxies-tomcat
Group: Development/Java
Summary:	Globus Java - SSL and proxy certificate support for Tomcat
License:	ASL 2.0
Requires:	%{name}-jsse = %{version}-%{release}

%description ssl-proxies-tomcat
Globus Java library with SSL and proxy certificate support for Tomcat
%endif

%package io
Group: Development/Java
Summary:	Globus Java - IO
License:	ASL 2.0
Requires:	%{name}-gram = %{version}-%{release}
Requires:	%{name}-gridftp = %{version}-%{release}

%description io
Globus Java library with IO utilities

%package myproxy
Group: Development/Java
Summary:	Globus Java - MyProxy
License:	ASL 2.0
Requires:	%{name}-gss = %{version}-%{release}

%description myproxy
Globus Java library with MyProxy support

%if %{gaxismodule}
%package axisg
Group: Development/Java
Summary:	Globus Java - Apache AXIS support
License:	ASL 2.0
Requires:	%{name}-gss = %{version}-%{release}

%description axisg
Globus Java library with Apache AXIS support
%endif

%package javadoc
Group: Development/Java
Summary:	Javadoc for %{name}
License:	ASL 2.0 and MIT
BuildArch: noarch

%description javadoc
This package contains the API documentation for %{name}.

%prep
%setup -q -n JGlobus-JGlobus-Release-%{version}
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1

# Do not package test classes
%mvn_package org.jglobus:container-test-utils __noinstall
%mvn_package org.jglobus:test-utils __noinstall

# Avoid build dependency bloat
%pom_remove_parent

# Don't do source and release
%pom_remove_plugin org.apache.maven.plugins:maven-release-plugin
%pom_remove_plugin org.apache.maven.plugins:maven-source-plugin

%if %{?fedora}%{!?fedora:0} >= 33 || %{?rhel}%{!?rhel:0} >= 8
# F33+ and EPEL8+ doesn't use the maven-javadoc-plugin to generate javadoc
# Remove maven-javadoc-plugin configuration to avoid build failure
%pom_remove_plugin org.apache.maven.plugins:maven-javadoc-plugin
%endif

%if ! %{gaxismodule}
%pom_disable_module axis
%endif

%if ! %{tomcatmodule}
%pom_disable_module ssl-proxies-tomcat
%endif

%build
# Many tests requires network connections and a valid proxy certificate
%mvn_build -f -s -- -Dmaven.compiler.source=1.8 -Dmaven.compiler.target=1.8 -Dmaven.javadoc.source=1.8 -Dmaven.compiler.release=8 -Ptomcat7 -Dproject.build.sourceEncoding=UTF-8

%install
%mvn_install

%files parent -f .mfiles-parent 
%doc --no-dereference LICENSE

%files ssl-proxies -f .mfiles-ssl-proxies
%dir %{_javadir}/%{name}
%doc README.textile
%doc --no-dereference LICENSE

%files jsse -f .mfiles-jsse

%files gss -f .mfiles-gss

%files gram -f .mfiles-gram

%files gridftp -f .mfiles-gridftp

%if %{tomcatmodule}
%files ssl-proxies-tomcat -f .mfiles-ssl-proxies-tomcat
%endif

%files io -f .mfiles-io

%files myproxy -f .mfiles-myproxy

%if %{gaxismodule}
%files axisg -f .mfiles-axisg
%doc axis/src/main/java/org/globus/axis/example/README.txt
%endif

%files javadoc -f .mfiles-javadoc

%changelog
