
%define formats rom
# PCI IDs (vendor,product) of the ROMS we want for QEMU
#
#    pcnet32: 0x1022 0x2000
#   ne2k_pci: 0x10ec 0x8029
#      e1000: 0x8086 0x100e
#    rtl8139: 0x10ec 0x8139
# virtio-net: 0x1af4 0x1000
#   eepro100: 0x8086 0x1209
#     e1000e: 0x8086 0x10d3
#    vmxnet3: 0x15ad 0x07b0

%global qemuroms \\\
  10222000:pcnet \\\
  10ec8029:ne2k_pci \\\
  10ec8139:rtl8139 \\\
  15ad07b0:vmxnet3 \\\
  80861209:eepro100 \\\
  8086100e:e1000 \\\
  1af41000:virtio \\\
  808610d3:e1000e

%define date 20250122
%define hash c2f21a21

Name: ipxe
Version: %date
Release: alt2.git%{hash}
Epoch: 1

Summary: PXE boot firmware
License: GPL-2.0-only
Group: Networking/Other
Url: http://ipxe.org/
#Vcs-Git: git://git.ipxe.org/ipxe.git
ExclusiveArch: x86_64

Provides: gpxe = %EVR
Obsoletes: gpxe < %EVR

Source: %name-%version.tar
Patch: %name-%version.patch

Requires: ipxe-bootimgs
BuildRequires: xorriso mtools syslinux binutils-devel edk2-tools
BuildRequires: liblzma-devel
BuildRequires: gcc-aarch64-linux-gnu binutils-aarch64-linux-gnu

%description
iPXE is the leading open source network boot firmware.
It provides a full PXE implementation enhanced with additional features such as:
- boot from a web server via HTTP
- boot from an iSCSI SAN
- boot from a Fibre Channel SAN via FCoE
- boot from an AoE SAN
- boot from a wireless network
- boot from a wide-area network
- boot from an Infiniband network
- control the boot process with a script

You can use iPXE to replace the existing PXE ROM on your network card,
or you can chainload into iPXE to obtain the features of iPXE without the hassle of reflashing.

%package bootimgs
Summary: Network boot loader images in bootable USB, CD, floppy and GRUB formats
Group: Development/Tools
BuildArch: noarch
Provides: gpxe-bootimgs = %EVR
Obsoletes: gpxe-bootimgs < %EVR

%description bootimgs
iPXE is an implementation of the PXE specification for network
booting, with extensions to allow additional features such as booting
via HTTP, iSCSI, and AoE.

This package contains the iPXE boot images in USB, CD, floppy, and PXE
UNDI formats.

%package roms
Summary: Network boot loader roms in .rom format
Group: Development/Tools
BuildArch: noarch
Requires: %name-roms-qemu = %EVR
Provides: gpxe-roms = %EVR
Obsoletes: gpxe-roms < %EVR

%description roms
iPXE is an implementation of the PXE specification for network
booting, with extensions to allow additional features such as booting
via HTTP, iSCSI, and AoE.

This package contains the iPXE roms in .rom format.

%package roms-qemu
Summary: Network boot loader roms supported by QEMU, .rom format
Group: Development/Tools
BuildArch: noarch
Provides: gpxe-roms-qemu = %EVR
Obsoletes: gpxe-roms-qemu < %EVR

%description roms-qemu
iPXE is an implementation of the PXE specification for network
booting, with extensions to allow additional features such as booting
via HTTP, iSCSI, and AoE.

This package contains the iPXE ROMs for devices emulated by QEMU, in
.rom format.

%prep
%setup
%patch -p1

%build
cd src

# ath9k drivers are too big for an Option ROM, and ipxe devs say it doesn't
# make sense anyways
# http://lists.ipxe.org/pipermail/ipxe-devel/2012-March/001290.html
rm -rf drivers/net/ath/ath9k

make_ipxe() {
    %make_build \
        NO_WERROR=1 V=1 \
        GITVERSION=%hash \
        "$@"
}

make_ipxe bin-i386-efi/ipxe.efi \
        bin-x86_64-efi/ipxe.efi \
        bin-x86_64-efi/snponly.efi

make_ipxe ARCH=arm64 CROSS_COMPILE=aarch64-linux-gnu- \
        bin-arm64-efi/ipxe.efi \
        bin-arm64-efi/snponly.efi

make_ipxe ISOLINUX_BIN=/usr/lib/syslinux/isolinux.bin \
        bin/undionly.kpxe \
        bin/ipxe.{dsk,iso,usb,lkrn} \
        allroms

# build roms with efi support for qemu
mkdir bin-combined
for romstr in %qemuroms; do
  rom=$(echo "$romstr" | cut -d ":" -f 1)

  make_ipxe CONFIG=qemu bin/${rom}.rom
  make_ipxe CONFIG=qemu bin-x86_64-efi/${rom}.efidrv
  vid="0x${rom%%????}"
  did="0x${rom#????}"
  EfiRom -f "$vid" -i "$did" --pci23 \
         -ec bin-x86_64-efi/${rom}.efidrv \
         -o  bin-combined/${rom}.eficrom

  util/catrom.pl \
      bin/${rom}.rom \
      bin-combined/${rom}.eficrom \
      > bin-combined/${rom}.rom
  EfiRom -d  bin-combined/${rom}.rom
  # truncate to at least 256KiB
  truncate -s \>256K bin-combined/${rom}.rom
  # verify rom fits in 256KiB
  test $(stat -c '%%s' bin-combined/${rom}.rom) -le $((256 * 1024))
done


%install
mkdir -p %buildroot%_datadir/%name
mkdir -p %buildroot%_datadir/%name.efi

pushd src/bin/

install -pm0644 undionly.kpxe ipxe.{iso,usb,dsk,lkrn}  %buildroot%_datadir/%name

for img in *.rom; do
  if [ -e $img ]; then
   cp -a $img %buildroot%_datadir/%name/
   echo %_datadir/%name/$img >> ../../rom.list
  fi
done
popd

cp -a src/bin-i386-efi/ipxe.efi %buildroot/%_datadir/%name/ipxe-i386.efi
cp -a src/bin-x86_64-efi/ipxe.efi %buildroot/%_datadir/%name/ipxe-x86_64.efi
cp -a src/bin-x86_64-efi/snponly.efi %buildroot/%_datadir/%name/snponly-x86_64.efi
cp -a src/bin-arm64-efi/ipxe.efi %buildroot/%_datadir/%name/ipxe-arm64.efi
cp -a src/bin-arm64-efi/snponly.efi %buildroot/%_datadir/%name/snponly-arm64.efi

# the roms supported by qemu will be packaged separatedly
# remove from the main rom list and add them to qemu.list
for romstr in %qemuroms; do
  rom=$(echo "$romstr" | cut -d ":" -f 1)
  qemuname=$(echo "$romstr" | cut -d ":" -f 2)
  sed -i -e "/\/${rom}.rom/d" rom.list
  echo %_datadir/%name/${rom}.rom >> qemu.rom.list
 
  cp src/bin-combined/${rom}.rom %buildroot/%_datadir/%name.efi/
  echo %_datadir/%name.efi/${rom}.rom >> qemu.rom.list

  ln -r -s %buildroot%_datadir/%name/${rom}.rom %buildroot%_datadir/%name/pxe-${qemuname}.rom
  ln -r -s %buildroot%_datadir/%name.efi/${rom}.rom %buildroot%_datadir/%name.efi/efi-${qemuname}.rom
done

%files bootimgs
%_datadir/%name/ipxe.iso
%_datadir/%name/ipxe.usb
%_datadir/%name/ipxe.dsk
%_datadir/%name/ipxe.lkrn
%_datadir/%name/ipxe-i386.efi
%_datadir/%name/ipxe-x86_64.efi
%_datadir/%name/snponly-x86_64.efi
%_datadir/%name/undionly.kpxe
%_datadir/%name/ipxe-arm64.efi
%_datadir/%name/snponly-arm64.efi
%doc COPYING COPYING.GPLv2 COPYING.UBDL

%files roms -f rom.list
%doc COPYING COPYING.GPLv2 COPYING.UBDL

%files roms-qemu -f qemu.rom.list
%doc COPYING COPYING.GPLv2 COPYING.UBDL
%dir %_datadir/%name
%_datadir/%name/pxe-*.rom
%dir %_datadir/%name.efi
%_datadir/%name.efi/efi-*.rom

%changelog
