%def_with libatm
%def_with selinux

Name: iproute2
Version: 6.16.0
Release: alt1

Summary: Advanced IP routing and network devices configuration tools
License: GPLv2+
Group: Networking/Other
Url: https://wiki.linuxfoundation.org/networking/iproute2
# git://git.altlinux.org/gears/i/%name.git
Source: %name-%version-%release.tar

Provides: iproute = %version-%release
Obsoletes: iproute < %version, %name-doc < %version

# Automatically added by buildreq on Mon Jan 07 2019
BuildRequires: flex libcap-devel libdb4-devel libelf-devel libiptables-devel libmnl-devel
%{?_with_libatm:BuildRequires: libatm-devel}
%{?_with_selinux:BuildRequires: libselinux-devel}

%description
iproute2 is a collection of utilities to control Linux networking and some
other subsystems. It consists of several tools, of which the most important are
ip(8) and tc(8).

%package devel
Summary: Headers and development files for iproute2
Group: Development/C
Requires: iproute2 = %version-%release

%description devel
iproute2 is a collection of utilities to control Linux networking and some
other subsystems. It consists of several tools, of which the most important are
ip(8) and tc(8).

This package contains C headers to develop auxiliary code for programmable
subsystems, like tc-bpf.

%package -n arpd
Summary: The arpd daemon
Group: Networking/Other
Requires: %name = %version-%release

%description -n arpd
arpd is a daemon collecting gratuitous ARP information, saving it on
local disk and feeding it to kernel on demand to avoid redundant
broadcasting due to limited size of kernel ARP cache.

%prep
%setup -n %name-%version-%release

%build
%make_build DBM_INCLUDE=%_includedir/db4 CONF_USR_DIR=%_datadir/iproute2 LIBDIR=%_libdir CCOPTS='%optflags' V=1

%install
%makeinstall_std CONF_USR_DIR=%_datadir/iproute2 LIBDIR=%_libdir
mkdir -p %buildroot{%_bindir,%_sbindir,%_localstatedir/arpd}
pushd %buildroot/sbin
rm routel
mv arpd bridge ctstat genl ifstat lnstat nstat rtacct rtstat ss tipc \
	%buildroot%_sbindir/
popd
rm %buildroot%_man8dir/routel.8
mkdir -p %buildroot%_sysconfdir/iproute2

# symlinks for unprivileged users
for prg in ip rtmon tc; do
	ln -rs %buildroot/sbin/$prg %buildroot%_bindir/
done
for prg in lnstat nstat ss; do
	ln -rs %buildroot%_sbindir/$prg %buildroot%_bindir/
done

%define _stripped_files_terminate_build 1
%define _unpackaged_files_terminate_build 1

%files
/sbin/*
%_sbindir/*
%_bindir/*
%_libdir/tc/
%exclude %_sbindir/arpd
%_datadir/%name
%config(noreplace) %_sysconfdir/%name
%_man7dir/*
%_man8dir/*
%_datadir/bash-completion/completions/*
%doc README*

%files devel
%_includedir/iproute2
%_man3dir/libnetlink.3*

%files -n arpd
%_sbindir/arpd
%attr(700,root,root) %dir %_localstatedir/arpd

%changelog
