%define ver_major 0.51

Name: intltool
Version: %ver_major.0
Release: alt2

Summary: Scripts and assorted auto* magic for i18nalizing various kinds of data files
License: %gpl2plus
Group: Development/GNOME and GTK+
Url: http://www.freedesktop.org/wiki/Software/%name

Source: https://launchpad.net/intltool/trunk/%version/+download/%name-%version.tar.gz
Patch: %name-0.50.2-alt-intltoolize.patch
# https://bugs.launchpad.net/intltool/+bug/1505260
# https://bugzilla.redhat.com/show_bug.cgi?id=1249051
Patch2: intltool-merge-Create-cache-file-atomically.patch
# Fix intltool-update to work with perl 5.26.
# Patch taken from fedora
Patch3: intltool-perl5.26-regex-fixes.patch

Requires: perl-XML-Parser
Obsoletes: xml-i18n-tools
Provides: xml-i18n-tools = %version

BuildArch: noarch

BuildPreReq: rpm-build-licenses rpm-build-gnome
BuildRequires: perl-XML-Parser perl-Encode perl-devel

%description
The intltool collection can be used to do these things:

 o Extract translatable strings from various source files (.xml.in,
   .glade, .desktop.in, .server.in, .oaf.in).

 o Collect the extracted strings together with messages from traditional
   source files (.c, .h) in po/$(PACKAGE).pot.

 o Merge back the translations from .po files into .xml, .desktop and
   .oaf files.  This merge step will happen at build resp. installation
   time.

%prep
%setup
%patch
%patch2 -p1
%patch3 -p1

%build
%configure
%make_build

%install
%makeinstall_std

%check
%make check

%files
%_bindir/*
%_datadir/%name/
%_datadir/aclocal/*
%_man8dir/*
%doc AUTHORS README TODO NEWS ChangeLog doc/*-HOWTO

%changelog
