%define shortname indi
%define name_common %{shortname}lib-common

Name: %{shortname}lib
Version: 1.9.0
Release: alt3

%define _unpackaged_files_terminate_build 1
# This package tries to mix and match PIE and PIC which is wrong and will
# trigger link errors when LTO is enabled.
# Disable LTO
%global optflags_lto %nil

%add_verify_elf_skiplist %_libdir/libindidriver.so.%version
%add_verify_elf_skiplist %_libdir/libindimain.so.%version
%add_verify_elf_skiplist %_libdir/libindiAlignmentDriver.so.%version
%add_verify_elf_skiplist %_libdir/libindilx200.so.%version

Group: Development/C
Summary: Library to control astronomical devices
Url: http://indi.sourceforge.net/
License: LGPLv2+

Provides: %shortname = %version-%release
Conflicts: kde4edu-kstars < 4.1.60
Conflicts: kdeedu-kstars <= 3.5.10-alt2

# http://nchc.dl.sourceforge.net/sourceforge/indi/
Source: %{shortname}-%version.tar

# Automatically added by buildreq on Wed Oct 05 2011 (-bi)
# optimized out: cmake-modules elfutils libstdc++-devel pkg-config zlib-devel
#BuildRequires: boost-devel-headers cmake gcc-c++ libcfitsio-devel libnova-devel libusb-compat-devel zlib-devel-static
BuildRequires: boost-devel cmake gcc-c++ libcfitsio-devel libnova-devel libusb-compat-devel zlib-devel
BuildRequires: libfftw3-devel
BuildRequires: libusb-devel libjpeg-devel libgsl-devel libcurl-devel libtheora-devel
BuildRequires: kde-common-devel

Patch0: libindi-uaccess.patch
Patch1: libindi-gcc11.patch
Patch2: indilib-1.9.0-alt-fix-cmake-compilation.patch

%description
INDI is an instrument neutral distributed interface control protocol
that aims to provide backend driver support and automation for a wide
range of Astronomical devices (telescopes, focusers, CCDs..etc).

%package -n %name_common
Summary: %name common package
Group: System/Configuration/Other
BuildArch: noarch
Conflicts: indilib <= 1.5.0-alt2
%description -n %name_common
%name common package

%package -n libsbigudrv
Summary: Librar file for INDI
Group: Development/C
Requires: %{name_common} = %EVR
%description -n libsbigudrv
  INDI is an instrument neutral distributed interface control protocol
that aims to provide backend driver support and automation for a wide
range of Astronomical devices (telescopes, focusers, CCDs..etc).
  This package contains library files of indilib.

%package -n lib%shortname
Group: System/Libraries
Summary: Library to control astronomical devices
Requires: %{name_common} = %EVR
%description -n lib%shortname
INDI is an instrument neutral distributed interface control protocol
that aims to provide backend driver support and automation for a wide
range of Astronomical devices (telescopes, focusers, CCDs..etc).

%package -n lib%shortname-devel
Summary: INDI devellopment files
Group: Development/C
Requires: %{name_common} = %EVR
Provides: %shortname-devel = %version-%release
Provides: %{shortname}lib-devel = %version-%release
Obsoletes: %{shortname}lib-devel < %version-%release

%description -n lib%shortname-devel
  INDI is an instrument neutral distributed interface control protocol
that aims to provide backend driver support and automation for a wide
range of Astronomical devices (telescopes, focusers, CCDs..etc).
  This package contains files need to build applications using indilib.

%package -n lib%shortname-devel-static
Summary: INDI static libraries
Group: Development/C
Requires: lib%shortname-devel = %EVR
Conflicts: lib%{shortname}-devel < 1.8.9-alt1

%description -n lib%shortname-devel-static
  INDI is an instrument neutral distributed interface control protocol
that aims to provide backend driver support and automation for a wide
range of Astronomical devices (telescopes, focusers, CCDs..etc).
  This package contains files need to build applications using indilib.

%prep
%setup -n %{shortname}-%version
%patch0 -p1
%patch1 -p1
%patch2 -p2

%ifarch %e2k
# strip UTF-8 BOM for lcc < 1.24
find -type f -name '*.cpp' -o -name '*.hpp' |
	xargs sed -ri 's,^\xEF\xBB\xBF,,'
%endif

%build
%Kbuild \
    -DUDEVRULES_INSTALL_DIR=%_udevrulesdir \
    #

%install
%Kinstall

%files common
%doc ChangeLog README
# an essential part of libindi according to FindINDI.cmake
%_datadir/%shortname/

%files
%_bindir/*
%_udevrulesdir/*.rules

%files -n lib%shortname
#%_libdir/libindi.so.1
#%_libdir/libindi.so.1.*
%_libdir/libindiAlignmentDriver.so.1
%_libdir/libindiAlignmentDriver.so.1.*
%_libdir/libindidriver.so.1
%_libdir/libindidriver.so.1.*
%_libdir/libindilx200.so.1
%_libdir/libindilx200.so.1.*
# an essential part of libindi according to FindINDI.cmake
%_libdir/%shortname/MathPlugins

#%files -n libsbigudrv
#%_libdir/libsbigudrv.so.*

%files -n lib%shortname-devel
#%doc src/examples
%_libdir/*.so
%_includedir/libindi
%_pkgconfigdir/libindi.pc

%files -n lib%shortname-devel-static
%_libdir/*.a

%changelog
