%def_enable snapshot
%define ver_major 3.5
%define rdn_name io.gitlab.adhami3310.Impression

%def_disable bootstrap
%def_enable check

Name: impression
Version: %ver_major.3
Release: alt1

Summary: Impression is a tool to create bootable drives
License: GPL-3.0-or-later
Group: System/Configuration/Other
Url: https://gitlab.com/adhami3310/Impression

Vcs: https://gitlab.com/adhami3310/Impression.git
# hardcode ALT (not usable for >= 3.5.2)
# see gchema.override below
Patch2: %name-3.3.0-alt-add-alt-to-list.patch

%if_disabled snapshot
Source: %url/-/archive/v%version/%name-%version.tar.gz
%else
Source: %name-%version.tar
%endif
Source1: %name-%version-cargo.tar

%define gtk_ver 4.10
%define adwaita_ver 1.5

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson rust-cargo
BuildRequires: blueprint-compiler
BuildRequires: pkgconfig(gtk4) >= %gtk_ver
BuildRequires: pkgconfig(libadwaita-1) >= %adwaita_ver gir(Adw)
BuildRequires: pkgconfig(openssl)
BuildRequires: pkgconfig(dbus-1)
%{?_enable_check:BuildRequires: /usr/bin/appstreamcli desktop-file-utils /usr/bin/glib-compile-schemas}

%description
A tool to write images to portable drives like flash drives or memory
cards.

%prep
%setup -n %name-%version %{?_disable_bootstrap:-a1}
%{?_enable_bootstrap:
mkdir .cargo
cargo vendor | sed 's/^directory = ".*"/directory = "vendor"/g' > .cargo/config.toml
tar -cf %_sourcedir/%name-%version-cargo.tar .cargo/ vendor/}

%build
%meson
%meson_build

%install
%meson_install
cat << _EOF_\
> %buildroot/%_datadir/glib-2.0/schemas/%rdn_name.gschema.override
[io.gitlab.adhami3310.Impression]
downloadable-distros=[('altlinux.org', nothing, false)]
_EOF_

%find_lang %name

%check
%__meson_test

%files -f %name.lang
%_bindir/%name
%_desktopdir/%rdn_name.desktop
%_datadir/%name/
%_datadir/glib-2.0/schemas/%rdn_name.gschema.xml
%_datadir/glib-2.0/schemas/%rdn_name.gschema.override
%_datadir/dbus-1/services/%rdn_name.service
%_iconsdir/hicolor/*/*/*.svg
%_datadir/metainfo/%rdn_name.metainfo.xml
%doc PRESS* README*


%changelog
