%define sover 1

Name: imlib2
Version: 1.12.5
Release: alt1

Summary: Image loading, saving, rendering, and manipulation library
License: Imlib2
Group: System/Libraries
Url: https://git.enlightenment.org/old/legacy-imlib2
Vcs: https://git.enlightenment.org/old/legacy-imlib2.git
# Source-url: https://sourceforge.net/projects/enlightenment/files/imlib2-src/%version/%name-%version.tar.xz
Source: %name-%version.tar

%def_disable static
%def_enable mmx

# Automatically added by buildreq on Sun Sep 16 2012
# optimized out: gnu-config libX11-devel pkg-config xorg-xextproto-devel xorg-xproto-devel zlib-devel
BuildRequires: gcc-c++ libgomp-devel
BuildRequires: bzlib-devel libXext-devel libfreetype-devel libgif-devel libjpeg-devel libpng-devel libwebp-devel libtiff-devel libid3tag-devel libraw-devel libyuv-devel
%ifnarch armh
BuildRequires: libjxl-devel
%endif
BuildRequires: libheif-devel librsvg-devel liblzma-devel libopenjpeg2.0-devel libspectre-devel

%description
Imlib 2 is a library that does image file loading and saving as well as
rendering, manipulation, arbitrary polygon support, etc.  It does ALL of
these operations FAST.  Imlib2 also tries to be highly intelligent about
doing them, so writing naive programs can be done easily, without
sacrificing speed.  This is a complete rewrite over the Imlib 1.x
series.  The architecture is more modular, simple, and flexible.

%package devel
Summary: Imlib2 development files
Group: Development/C
Requires: %name = %version-%release

%description devel
This package contains development files for Imlib2.

%package devel-static
Summary: Imlib static libraries
Group: Development/C
Requires: %name-devel = %version-%release

%description devel-static
Imlib2 static libraries.

%package utils
Summary: Imlib2 image manipulation and testing utilities.
Group: Graphics
Requires: %name = %version-%release

%description utils
Imlib2 is an advanced replacement library for libraries like libXpm
that provides many more features with much greater flexibility and
speed than standard libraries, including font rasterization, rotation,
RGBA space rendering and blending, dynamic binary filters, scripting,
and more.

This package provides some test programs and utilities from Imlib2
distribution.

%prep
%setup
#sed -i 's/echo \$libdirs -lImlib2 @my_libs@/echo -lImlib2/' imlib2-config.in
sed -i '1a#include <stdbool.h>' \
  src/modules/loaders/loader_gif.c

%build
export LIBS+=" -lwebp -L/%_lib -lm"
%autoreconf
%configure \
	%{subst_enable static} \
%ifarch x86_64
	--enable-amd64 \
%endif
%ifarch %ix86
	%{subst_enable mmx} \
%endif
	--enable-visibility-hiding

%make_build

%install
%makeinstall_std

# remove non-packaged files
find %buildroot%_libdir/ -name '*.la' -delete

%check
make check

%files
%_libdir/*.so.%{sover}*
%dir %_libdir/%name/
%dir %_libdir/%name/filters/
%dir %_libdir/%name/loaders/
%_libdir/%name/filters/*.so
%_libdir/%name/loaders/*.so

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*
# %%doc doc/{*gif,*.html}

%files utils
%_bindir/*
%_datadir/%name/

%if_enabled static
%files devel-static
%_libdir/lib*.a
%_libdir/%name/*/*.a
%endif

%changelog
