%define _unpackaged_files_terminate_build 1
%def_without old_make_initrd

Name: ima-evm-integrity-check
Epoch: 1
Version: 0.8.0
Release: alt1

Summary: IMA/EVM integrity check
License: %gpl2plus
Group: System/Base
Packager: Paul Wolneykien <manowar@altlinux.org>

Source: %name-%version.tar

BuildRequires(pre): rpm-build-licenses
BuildRequires: bash4

BuildArch: noarch

Requires: make-initrd-integrity = %version-%release
%if_without old_make_initrd
Requires: make-initrd >= 2.0.0
%endif

Requires: /usr/bin/chattr

Obsoletes: cert-distro-updater < %EVR
Provides: cert-distro-updater = %EVR
Conflicts: cert-distro-updater < %EVR

Obsoletes: updater < %EVR
Provides: updater = %EVR
Conflicts: updater < %EVR

%description
This package make use of the IMA and EVM technologies from the Linux
integrity subsystem. Basically IMA and EVM provide the following
functionality:

- measurement (hashing) of file content as it is accessed and keeping
  track of this information in an audit log;
- appraisal of files, which allows to prevent access when
  a measurement (hash) or digital signature does not match
  the expected value.

This package requires kernel with corresponding config options enabled.

%package -n make-initrd-integrity
Summary: Integrity check feature for make-initrd
Group: System/Base

# For put-file utility
Requires: make-initrd >= 0.7.6-alt1
%if_with old_make_initrd
Conflicts: make-initrd >= 2.0.0
%endif

Requires: coreutils grep kmod mount

Requires: keyutils ima-evm-utils
Requires: filesystem >= 2.3.13-alt1.M80C.1
Conflicts: cert-distro-updater < %EVR

%description -n make-initrd-integrity
Integrity check feature for make-initrd

%prep
%setup

%build
%make_build libdir=%_libdir prefix=%_prefix sysconfdir=%_sysconfdir WITH_OLD_MI=%{with old_make_initrd}

%install
%makeinstall_std bindir=%_bindir sbindir=%_sbindir sysconfdir=%_sysconfdir datadir=%_datadir unitdir=%_unitdir presetdir=%_presetdir libdir=%_libdir prefix=%_prefix controldir=%_controldir mandir=%_mandir WITH_OLD_MI=%{with old_make_initrd}

%add_findreq_skiplist %_datadir/make-initrd/features/integrity/data/etc/rc.d/init.d/integrity

# For ghost:
mkdir -p %buildroot%_sysconfdir/sysconfig
touch %buildroot%_sysconfdir/sysconfig/integrity

%files
%doc README
%_sbindir/*
%_controldir/*
%_unitdir/*
%_presetdir/*
%ghost %_sysconfdir/sysconfig/integrity
%config(noreplace) %_sysconfdir/integrity/config
%_man7dir/*.7.*
%_man8dir/*.8.*

%files -n make-initrd-integrity
%dir %_sysconfdir/integrity
%_datadir/integrity
%dir %_datadir/make-initrd/features/integrity
%_datadir/make-initrd/features/integrity/*.mk
%dir %_datadir/make-initrd/features/integrity/data
%if_without old_make_initrd
%dir %_datadir/make-initrd/features/integrity/data/etc
%dir %_datadir/make-initrd/features/integrity/data/etc/rc.d
%dir %_datadir/make-initrd/features/integrity/data/etc/rc.d/init.d
%_datadir/make-initrd/features/integrity/data/etc/rc.d/init.d/integrity
%else
%dir %_datadir/make-initrd/features/integrity/data/lib
%dir %_datadir/make-initrd/features/integrity/data/lib/initrd
%dir %_datadir/make-initrd/features/integrity/data/lib/initrd/modules
%_datadir/make-initrd/features/integrity/data/lib/initrd/modules/085-integrity
%endif

%changelog
