# no git-version-gen in tarball
%def_enable snapshot

Name: ifuse
Version: 1.2.0
Release: alt1

Summary: Filesystem access for the iPhone and iPod Touch
Group: Communications
License: LGPL-2.1
Url: http://www.libimobiledevice.org/

Vcs: https://github.com/libimobiledevice/ifuse

%if_disabled snapshot
#Source: %url/downloads/%name-%version.tar.bz2
Source: https://github.com/libimobiledevice/ifuse/releases/download/%version/%name-%version.tar.bz2
%else
Source: %name-%version.tar
%endif

%define fuse_ver 3.0
%define plist_ver 2.2.0
%define imobiledevice_ver 1.4.0

Requires: fuse3 >= %fuse_ver

BuildRequires: libfuse3-devel >= %fuse_ver
BuildRequires: libplist-devel >= %plist_ver
BuildRequires: libimobiledevice-devel >= %imobiledevice_ver

%description
iFuse is a FUSE filesystem driver which uses libiphone to connect to devices
without the need for a jailbreak.
It is using the native Apple "AFC" protocol, over the normal USB cable in order
to access the iPhone's or iPod Touch's media files under Linux.

%prep
%setup
echo %version > .tarball-version

%build
%add_optflags %(getconf LFS_CFLAGS)
%autoreconf
%configure
%make_build

%install
%makeinstall_std

%files
%_bindir/ifuse
%_man1dir/ifuse.1*
%doc AUTHORS README*

%changelog
