%define real_ver_major 74
%define real_ver_minor 2
%define real_ver %{real_ver_major}.%{real_ver_minor}

%def_without doc

Name: icu%real_ver_major
Version: %(echo %real_ver_major | sed -e 's|\(.\)|\1.|').%real_ver_minor
Release: alt2
Epoch: 1

Summary: International Components for Unicode
Group: System/Legacy libraries
License: ICU and BSD-3-Clause and Unicode-TOU and naist-2003
Url: http://www.icu-project.org/

Source: http://download.icu-project.org/files/icu4c/%real_ver/icu4c-%{real_ver_major}_%{real_ver_minor}-src.tgz
Source1: LICENSE-Unicode-v3
Patch: icu-6.3.1-alt-e2k.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: autoconf-archive gcc-c++ libstdc++-devel python3-base
%{?_with_doc:BuildRequires: doxygen}

%define libicu libicu%real_ver_major

%description
ICU is a C++ and C library that provides robust and full-featured Unicode
support

%package -n %libicu
Summary: International Components for Unicode (libraries)
Group: System/Libraries
Provides: libicu = %epoch:%version-%release
Obsoletes: libicu < %epoch:%version-%release

%description -n %libicu
ICU is a C++ and C library that provides robust and full-featured Unicode
support. This package contains the runtime libraries for ICU.

%prep
%setup -c
%setup -DT -n %name-%version/icu
cp %SOURCE1 ../LICENSE
%ifarch %e2k
%patch -p2
%add_optflags -finput-charset=utf8
%endif

sed -ri '/^LDFLAGSICUDT=/ s,-nodefaultlibs -nostdlib,,' source/config/mh-linux

# switch to zone1970.tab
sed -i 's|zone\.tab|zone1970.tab|' source/tools/tzcode/*

%build
export PYTHON=%__python3
%add_optflags %(getconf LFS_CFLAGS)
cd source
%autoreconf
%configure \
	--disable-samples \
	--disable-static \
	--with-data-packaging=library
%make_build

%install
cd source
%makeinstall_std

%files -n %libicu
%_libdir/*.so.*

%exclude %_bindir/*
%exclude %_sbindir/*
%exclude %_libdir/*.so
%exclude %_libdir/icu/
%exclude %_includedir/*
%exclude %_pkgconfigdir/*.pc
%exclude %_datadir/icu/%real_ver/
%exclude %_man1dir/*
%exclude %_man8dir/*

%changelog
