%define _unpackaged_files_terminate_build 1
%global _libexecdir %prefix/libexec

Name: icmake
Version: 13.03.00
Release: alt1
Summary: A make utility using a C-like syntax
License: GPLv3
Group: Development/Tools
Url: https://gitlab.com/fbb-git/icmake
VCS: https://gitlab.com/fbb-git/icmake.git
Source: %name-%version.tar
Patch0: %name-%version-%release.patch
BuildRequires: gcc-c++

%description
Icmake (Intelligent C-like MAKE) is a hybrid between a make utility and a
shell script language, designed for software development and system
administration. Unlike traditional make, icmake uses a C-like scripting
language, giving developers more power and flexibility when defining build
rules or automating tasks.

It includes a compiler, executor, and utilities to support cross-platform
script execution. Icmake is especially useful for managing complex build
environments and packaging systems.

%package doc
Summary: Documentation for Icmake
Group: Development/Documentation
BuildArch: noarch

%description doc
Icmake (Intelligent C-like MAKE) is a hybrid between a make utility and a
shell script language, designed for software development and system
administration. Unlike traditional make, icmake uses a C-like scripting
language, giving developers more power and flexibility when defining build
rules or automating tasks.

It includes a compiler, executor, and utilities to support cross-platform
script execution. Icmake is especially useful for managing complex build
environments and packaging systems.

This package contains documentation for Icmake.

%prep
%setup
%patch0 -p1

%build
echo "/* created during rpmbuild */" >  %name/INSTALL.im
echo "#define BINDIR      \"%_bindir\"" >>  %name/INSTALL.im
echo "#define SKELDIR     \"%_datadir/%name\"" >>  %name/INSTALL.im
echo "#define MANDIR      \"%_mandir\"" >>  %name/INSTALL.im
echo "#define LIBDIR      \"%_libexecdir/%name\"" >>  %name/INSTALL.im
echo "#define CONFDIR     \"%_sysconfdir/%name\"" >>  %name/INSTALL.im
echo "#define DOCDIR      \"%_docdir/%name-%version\"" >>  %name/INSTALL.im
export ICMAKE_CPPSTD=--std=c++26
pushd %name
./prepare /
./buildlib /
./build all
popd

%install
pushd %name
./install all %buildroot
popd

%files
%_sysconfdir/*
%_bindir/*
%_libexecdir/%name
%_datadir/%name
%_man1dir/*
%_man7dir/*

%files doc
%_docdir/%name-%version

%changelog
