%define _unpackaged_files_terminate_build 1

#can rust have debuginfo? Verify and fix! Likely issue in Makefile of itw.
%global debug_package %nil

# Version of java we run against
%define javaver 11
# Version of java we build by
%define buildjavaver 11

# Alternatives priority (rised by one number when jre bumped to 11 (as 11 < 18 :)
%define priority 110000
# jnlp prorocol gnome registry keys
%define gurlhandler    /desktop/gnome/url-handlers
%define jnlphandler    %gurlhandler/jnlp
%define jnlpshandler   %gurlhandler/jnlps

%define jredir         %_jvmdir/jre-%javaver-openjdk

%define preffered_jre  java-%javaver-openjdk
%define preffered_jdk  java-%buildjavaver-openjdk-devel

Name: icedtea-web
Version: 2.0.0.alpha26
Release: alt2_jpp11

Summary: Additional Java components for OpenJDK - Java Web Start implementation
Group: Networking/WWW
License: LGPLv2+ and GPLv2 with exceptions
Url: https://github.com/AdoptOpenJDK/IcedTea-Web

Source: %name-%version.tar

Patch: %name-%version-alt.patch

BuildRequires(pre): rpm-macros-java
BuildRequires(pre): rpm-macros-alternatives
BuildRequires: /proc rpm-build-java
BuildRequires: /usr/bin/desktop-file-install
BuildRequires: %preffered_jdk
BuildRequires: desktop-file-utils
BuildRequires: dos2unix
BuildRequires: rust
BuildRequires: rust-cargo
BuildRequires: libappstream-glib
BuildRequires: junit
BuildRequires: maven
BuildRequires: hamcrest
BuildRequires: tagsoup
BuildRequires: maven-local
BuildRequires: maven-source-plugin
BuildRequires: maven-install-plugin
BuildRequires: maven-shade-plugin
BuildRequires: exec-maven-plugin
BuildRequires: hamcrest
BuildRequires: hamcrest-core
BuildRequires: rhino
BuildRequires: IPAddress

# For functionality and the OpenJDK dirs
Requires: %preffered_jre
Requires: javapackages-tools
Requires: rhino
Requires: IPAddress
Requires: tagsoup

#maven fragments
Requires(post):      javapackages-tools
Requires(postun):    javapackages-tools

%description
The IcedTea-Web project provides a an implementation of Java Web Start
(originally based on the Netx project, now opensource part of OpenWebStart)
and a settings tool to manage deployment settings for the aforementioned
Web Start implementations.

%package javaws
Summary: Java Web Start launcher
Group: Networking/Other

Provides: javaws = %javaver
Provides: %preffered_jre-javaws = %javaver
Provides: mozilla-plugin-java-1.8.0-openjdk
Obsoletes: mozilla-plugin-java-1.7.0-openjdk
Obsoletes: mozilla-plugin-java-1.8.0-openjdk

# Post requires alternatives to install tool alternatives.
# jnlp protocols support
Requires(post):   GConf libGConf
# Postun requires alternatives to uninstall tool alternatives.
# jnlp protocols support
Requires(postun):   GConf libGConf
Requires(post,preun): alternatives

%description javaws
Java Web Start is a deployment solution for Java-technology-based
applications. It is the plumbing between the computer and the Internet
that allows the user to launch and manage applications right off the
Web. Java Web Start provides easy, one-click activation of
applications, and guarantees that you are always running the latest
version of the application, eliminating complicated installation or
upgrade procedures.

%package javadoc
Group: Development/Java
Summary: API documentation for IcedTea-Web
Requires: %name = %version-%release
BuildArch: noarch

%description javadoc
This package contains Javadocs for the IcedTea-Web project.

%package devel
Group: Development/Java
Summary: pure sources for debugging IcedTea-Web
Requires: %name = %version-%release
BuildArch: noarch

%description devel
This package contains ziped sources of the IcedTea-Web project.

%prep
%setup
%patch -p1
dos2unix launchers/pom.xml

%pom_remove_plugin org.codehaus.mojo:buildnumber-maven-plugin
%pom_remove_plugin org.apache.maven.plugins:maven-source-plugin
%pom_remove_plugin org.jacoco:jacoco-maven-plugin
%pom_remove_plugin org.apache.maven.plugins:maven-surefire-plugin
%pom_add_plugin org.apache.maven.plugins:maven-install-plugin:2.5.2
%pom_remove_dep junit:junit common/pom.xml
%pom_remove_dep org.hamcrest:hamcrest common/pom.xml

%pom_remove_dep org.hamcrest:hamcrest test-extensions/pom.xml
%pom_remove_dep net.jcip:jcip-annotations test-extensions/pom.xml
%pom_remove_dep com.github.stefanbirkner:system-rules test-extensions/pom.xml

%pom_remove_dep com.github.vatbub:mslinks core/pom.xml
%pom_remove_dep org.hamcrest:hamcrest integration/pom.xml
%pom_remove_dep com.github.tomakehurst:wiremock-jre8 integration/pom.xml
%pom_remove_dep com.github.stefanbirkner:system-rules integration/pom.xml

# TODO: Add Javadoc support
%pom_remove_plugin org.apache.maven.plugins:maven-javadoc-plugin common/pom.xml
%pom_remove_plugin org.apache.maven.plugins:maven-javadoc-plugin core/pom.xml
%pom_remove_plugin org.apache.maven.plugins:maven-javadoc-plugin test-extensions/pom.xml
%pom_remove_plugin org.apache.maven.plugins:maven-javadoc-plugin xml-parser/pom.xml
%pom_remove_plugin org.apache.maven.plugins:maven-javadoc-plugin pom.xml

rm -v core/src/main/java/net/sourceforge/jnlp/util/WindowsDesktopEntry.java
rm -r integration/src

%build
rm -rf launchers/build.log
SPLASH_TARGET_DIR=%_datadir/%name \
ITW_TARGET_DIR=%_datadir/%name \
BIN_TARGET_DIR=%_libexecdir/%name \
ETC_TARGET_DIR=%_javaconfdir/%name \
ITW_LIBS=DISTRIBUTION \
JRE=%jredir \
%mvn_build --skip-javadoc -- -Plaunchers -Dmaven.test.skip=true -Dmaven.javadoc.skip=true || cat launchers/build.log

%install
%mvn_install

mkdir -p %buildroot%_libexecdir/%name
# build provides also .bat files, we do not want them
cp -v launchers/target%_libexecdir/%name/javaws %buildroot%_libexecdir/%name/
cp -v launchers/target%_libexecdir/%name/itweb-settings %buildroot%_libexecdir/%name/
cp -v launchers/target%_libexecdir/%name/policyeditor %buildroot%_libexecdir/%name/
cp -v launchers/target%_libexecdir/%name/javaws.sh %buildroot%_libexecdir/%name/
cp -v launchers/target%_libexecdir/%name/itweb-settings.sh %buildroot%_libexecdir/%name/
cp -v launchers/target%_libexecdir/%name/policyeditor.sh %buildroot%_libexecdir/%name/

mkdir -p %buildroot%_javaconfdir/%name/
cp -v launchers/target%_javaconfdir/%name/itw-modularjdk.args %buildroot%_javaconfdir/%name/

mkdir -p %buildroot%_datadir/%name
cp -v launchers/target%_datadir/%name/javaws_splash.png %buildroot%_datadir/%name/javaws_splash.png

mkdir -p %buildroot%_datadir/bash-completion/completions/
cp -v launchers/target/extensions/bash_completion.d/* %buildroot%_datadir/bash-completion/completions/

mkdir -p %buildroot%_mandir/
cp -r launchers/target/%name-docs/*/man/* %buildroot%_mandir/
# rename javaws so it can coexists with other implementations
mv %buildroot%_mandir/man1/javaws.1 %buildroot%_mandir/man1/javaws.itweb.1
mv %buildroot%_mandir/cs/man1/javaws.1 %buildroot%_mandir/cs/man1/javaws.itweb.1
mv %buildroot%_mandir/de/man1/javaws.1 %buildroot%_mandir/de/man1/javaws.itweb.1
mv %buildroot%_mandir/pl/man1/javaws.1 %buildroot%_mandir/pl/man1/javaws.itweb.1

rm -rf %buildroot%_mandir/man1/%name-plugin.1
rm -rf %buildroot%_mandir/*/man1/%name-plugin.1

# Install desktop files.
install -d -m 755 %buildroot%_desktopdir
install -d -m 755 %buildroot%_pixmapsdir
desktop-file-install --vendor '' --dir %buildroot%_desktopdir launchers/target/extensions/xdesktop/javaws.desktop
desktop-file-install --vendor '' --dir %buildroot%_desktopdir launchers/target/extensions/xdesktop/itweb-settings.desktop
desktop-file-install --vendor '' --dir %buildroot%_desktopdir launchers/target/extensions/xdesktop/policyeditor.desktop
cp launchers/target/libs/javaws.png %buildroot%_pixmapsdir

# install MetaInfo file for javaws
DESTDIR=%buildroot appstream-util install launchers/metadata/%name-javaws.appdata.xml

pushd %buildroot%_datadir/%name
ln -s ../java/%name/%name-all-dependencies.jar javaws.jar
popd

mkdir -p %buildroot%_sysconfdir/.java/deployment
echo "deployment.jre.dir=%jredir" > %buildroot%_sysconfdir/.java/deployment/deployment.properties

%find_lang %name --all-name --with-man

install -d %buildroot%_altdir
%__cat <<EOF >>%buildroot%_altdir/%name-javaws
%_bindir/javaws	%_libexecdir/%name/javaws	10
%_bindir/itweb-settings	%_libexecdir/%name/itweb-settings 10
%_bindir/policyeditor	%_libexecdir/%name/policyeditor 10
EOF

%files
%_mavenpomdir/*
%_javadir/*
%_datadir/maven-metadata/*
%doc README.md CONTRIBUTING.md
%doc --no-dereference LICENSE LICENCE_DETAILS.md

%files javaws -f %name.lang
%_datadir/bash-completion/completions/*
%dir %_javaconfdir/%name
%config(noreplace) %_javaconfdir/%name/itw-modularjdk.args
%_libexecdir/%name
%_datadir/%name
%_sysconfdir/.java/deployment/*
%_desktopdir/*
%_mandir/man1/*
%_pixmapsdir/*
%_datadir/appdata/*.xml
%doc README.md CONTRIBUTING.md
%doc --no-dereference LICENSE LICENCE_DETAILS.md
%_altdir/%name-javaws

%changelog
