%def_with clang

%global optflags_lto %optflags_lto -ffat-lto-objects

Name: hyprland
Version: 0.51.1
Release: alt1

Summary: Hyprland is a dynamic tiling Wayland compositor that doesn't sacrifice on its looks
License: BSD-3-Clause and MIT
Group: Graphical desktop/Other

Url: https://github.com/hyprwm/Hyprland

ExcludeArch: i586 armh
#Patch0: hyprland-0.40.0-native-udis86.patch
Patch1: hyprland-0.50.1-clang.patch
Patch2: hyprland-0.50.1-cm-inert-output.patch
Patch3: hyprland-0.50.1-fix-workspace-persistence.patch

# Source-url: https://github.com/hyprwm/Hyprland/releases/download/v%version/source-v%version.tar.gz
Source: %name-%version.tar

BuildRequires(pre): rpm-macros-meson

BuildRequires: meson cmake
BuildRequires: jq

%if_with clang
BuildRequires: clang libstdc++-devel
%else
BuildRequires: gcc-c++
%endif

BuildRequires: pkgconfig(hyprcursor)
BuildRequires: pkgconfig(hyprlang)
BuildRequires: pkgconfig(hyprwayland-scanner)
BuildRequires: pkgconfig(hyprutils)
BuildRequires: pkgconfig(hyprgraphics)
BuildRequires: pkgconfig(aquamarine)

BuildRequires: clang-devel libstdc++-devel
BuildRequires: glslang-devel
BuildRequires: libudis86-devel
BuildRequires: glibc-devel
BuildRequires: pkgconfig(cairo)
BuildRequires: pkgconfig(egl)
BuildRequires: pkgconfig(gbm) >= 17.1.0
BuildRequires: pkgconfig(gl)
BuildRequires: pkgconfig(re2)
BuildRequires: pkgconfig(gio-2.0)
BuildRequires: pkgconfig(glesv2)
BuildRequires: pkgconfig(libdrm) >= 2.4.118
BuildRequires: pkgconfig(libinput) >= 1.14.0
BuildRequires: pkgconfig(libseat) >= 0.2.0
BuildRequires: pkgconfig(libudev)
BuildRequires: pkgconfig(pixman-1) >= 0.42.0
BuildRequires: libpixman
BuildRequires: pkgconfig(vulkan) >= 1.2.182
BuildRequires: pkgconfig(pango)
BuildRequires: pkgconfig(uuid)

BuildRequires: pkgconfig(wayland-client)
BuildRequires: pkgconfig(wayland-protocols) >= 1.26
BuildRequires: pkgconfig(wayland-scanner)
BuildRequires: pkgconfig(wayland-server) >= 1.22
BuildRequires: pkgconfig(wayland-cursor)
BuildRequires: pkgconfig(wayland-egl)

BuildRequires: pkgconfig(xcb)
BuildRequires: pkgconfig(xcb-icccm)
BuildRequires: pkgconfig(xcb-errors)
BuildRequires: pkgconfig(xcb-renderutil)
BuildRequires: pkgconfig(xkbcommon)
BuildRequires: pkgconfig(xcursor)
BuildRequires: pkgconfig(xwayland)
BuildRequires: libdisplay-info-devel
BuildRequires: libtomlplusplus-devel
BuildRequires: glaze-devel

BuildRequires: pkgconfig(hwdata)
# systemd and uwsm
BuildRequires: pkgconfig(systemd)

# plugins
%if_with clang
Requires: llvm
%else
Requires: binutils
%endif

%description
Hyprland is a dynamic tiling Wayland compositor based on wlroots
that doesn't sacrifice on its looks.

It supports multiple layouts, fancy effects, has a very flexible IPC
model allowing for a lot of customization, and more.

%package uwsm
Summary: Hyprland session for uwsm
Group: Graphical desktop/Other
ExcludeArch: %ix86

Requires: %name
Requires: uwsm

%description uwsm
%summary.

%package devel
Summary: Static library and header files for the %name
Group: Development/C++

%description devel
%summary devel

%prep
%setup
%autopatch -p1

subst '/generateVersion\.sh/d' meson.build

%build
%meson \
    -Dsystemd=enabled \
	-Duwsm=enabled
%meson_build

%install
%meson_install

%files
%doc README.md LICENSE
%_bindir/Hyprland
%_bindir/hyprland
%_bindir/hyprctl
%_bindir/hyprpm

%_man1dir/Hyprland.1*
%_man1dir/hyprctl.1*

%_datadir/hypr/
%_datadir/wayland-sessions/%name.desktop
%_datadir/xdg-desktop-portal/%name-portals.conf

%_datadir/bash-completion/completions/hyprctl
%_datadir/bash-completion/completions/hyprpm

%_datadir/fish/vendor_completions.d/hyprctl.fish
%_datadir/fish/vendor_completions.d/hyprpm.fish

%_datadir/zsh/site-functions/_hyprctl
%_datadir/zsh/site-functions/_hyprpm

%files uwsm
%_datadir/wayland-sessions/%name-uwsm.desktop

%files devel
%_datadir/pkgconfig/%name-protocols.pc
%_datadir/pkgconfig/%name.pc
%_datadir/hyprland-protocols/
%_includedir/%name

%changelog
