Name: httperf
Version: 0.9.0
Release: alt4.git3209c7f9

Summary: Tool for measuring web server performance
License: GPLv2+ with exceptions
Group: Networking/WWW

URL:  https://github.com/httperf/httperf
#URL: http://www.hpl.hp.com/research/linux/httperf
Source0: %name-%version.tar
Patch0:  %name-%version-%release.patch
Source1: %name-paper-html.tar
Source2: ftp://ftp.hpl.hp.com/pub/httperf/httperf-paper.ps

# Automatically added by buildreq on Sat Sep 22 2018
# optimized out: glibc-kernheaders-generic glibc-kernheaders-x86 perl python-base python-modules python3 python3-base python3-dev ruby ruby-stdlibs sh3
BuildRequires: glibc-devel-static libssl-devel

%define pkgdocdir %_docdir/%name-%version

%description
httperf is a tool to measure web server performance. It speaks the HTTP protocol
both in its HTTP/1.0 and HTTP/1.1 flavors and offers a variety of workload
generators. While running, it keeps track of a number of performance metrics
that are summarized in the form of statistics that are printed at the end of a
test run.  The most basic operation of httperf is to generate a fixed number of
HTTP GET requests and to measure how many replies (responses) came back from the
server and at what rate the responses arrived.

%package docs
Summary: Documentation of a Tool for Measuring Web Server Performance
Group: Documentation
BuildArch: noarch

%description docs
httperf is a tool to measure web server performance. This package contains
HTML and PostScript documentation for it.

%prep
%setup
%patch0 -p1
tar xf %SOURCE1
mv %name html
install -m 0644 %SOURCE2 httperf-paper.ps

%build
%autoreconf
%configure
%make

%install
%makeinstall_std
# now docs...
install -d -m755 %buildroot%pkgdocdir
# by hand to avoid using %%doc purging the above
gzip httperf-paper.ps
install -p -m644 README.md httperf-paper.ps.gz %buildroot%pkgdocdir
cp -a html icons %buildroot%pkgdocdir

%files
%_bindir/*
%_man1dir/*
%dir %pkgdocdir
%pkgdocdir/README.md

%files docs
%dir %pkgdocdir
%pkgdocdir/html/
%pkgdocdir/icons/
%pkgdocdir/httperf-paper.ps.gz

%changelog
