%define webserver_cgibindir %_var/www/cgi-bin/
%define subscribers_dir /lib/resolvconf

Name: host2cat
Version: 1.01
Release: alt9

Summary: Custom DNS resolver
License: BSD
Group: System/Servers
Url: www.netpolice.ru

Source0: %name-%version.tar.gz
Source1: %name.init
Source2: %name.sysconfig
Source3: squid.conf
Source4: %name.openresolv
Source5: README.ALT.host2cat
Source6: %name.service
Patch0: host2cat-alt-fix-include-config.ph.patch
Patch1: host2cat-1.01-alt-fix_bind-addr-type.patch

BuildRequires: libadns-devel libmemcache-devel

# for findreq 
BuildRequires: perl-DBI perl-Net-DNS perl-CGI

# for apache2 user
Requires(pre): apache2-common
# for cgi-bin dir
Requires: apache2
Requires: apache2-htpasswd
Requires: perl-DBD-SQLite memcached
Requires: netpolice-filter squid-conf-%name squid-server >= 3.0
Requires: openresolv-%name

%description
DNS resolver for web content filtering with web interface.

%package -n squid-conf-%name
Summary: adapted squid config
Group: System/Servers
Requires: squid-common squid-helpers libshell
Requires: squid-server >= 3.1.19-alt2

%description -n squid-conf-%name
This package contains squid config adapted for %name.

%package -n openresolv-%name
Summary: host2cat subscriber for openresolv
Group: System/Configuration/Networking
Requires: openresolv
Requires: %name

%description -n openresolv-%name
host2cat subscriber for openresolv

%prep
%setup -q
%patch0 -p2
%patch1

%build
aclocal --force 
autoconf --force
autoheader --force
automake --add-missing --force-missing --foreign

%configure
%make_build

%install
mkdir -p %buildroot{%_cachedir/%name,%webserver_cgibindir,%_libexecdir/%name}

install -m0755 -D %name %buildroot%_sbindir/%name
install -m0755 -D %SOURCE1 %buildroot%_initdir/%name
install -m0644 -D %SOURCE2 %buildroot%_sysconfdir/sysconfig/%name
install -m0644 -D %SOURCE3 %buildroot%_sysconfdir/squid/squid.conf.host2cat
install -m0644 -D %SOURCE4 %buildroot%subscribers_dir/%name
install -m0644 -D %SOURCE5 %buildroot%_sysconfdir/squid/README.ALT.host2cat
install -m0644 -D %SOURCE6 %buildroot%_unitdir/%name.service

install -m0755 contrib/get_file.pl %buildroot%webserver_cgibindir/get_file.pl
install -m0644 scripts/config.ph %buildroot%webserver_cgibindir/config.ph
install -m0755 scripts/*.cgi %buildroot%webserver_cgibindir/
install -m0755 scripts/*.pl %buildroot%_libexecdir/%name/
install -m0644 scripts/*.schema %buildroot%_libexecdir/%name/
install -m0644 scripts/custom_roles scripts/generic_roles scripts/users %buildroot%_libexecdir/%name/

touch %buildroot%_cachedir/%name/filter.db

mkdir -p %buildroot%_sysconfdir/httpd2/conf/{extra-start.d,extra-available,mods-start.d}
cat << EOF > %buildroot%_sysconfdir/httpd2/conf/extra-start.d/030-host2cat.conf
host2cat=yes
EOF

cat << EOF > %buildroot%_sysconfdir/httpd2/conf/extra-available/host2cat.conf
<IfModule alias_module>
	ScriptAlias /cgi-bin/ "/var/www/cgi-bin/"
</IfModule>
EOF

cat << EOF > %buildroot%_sysconfdir/httpd2/conf/mods-start.d/030-host2cat.conf
alias=yes
cgi=yes
EOF

%post
%post_service %name
/usr/sbin/a2chkconfig &> /dev/null ||:
/sbin/service httpd2 condreload ||:
INITDB=%_libexecdir/%name/init_filter_db.pl
[ -x $INITDB ] && $INITDB -d %_libexecdir/%name/ dbi:SQLite:dbname=%_cachedir/%name/filter.db ||:

%preun
%preun_service %name

%post -n squid-conf-%name
# Make Squid autostart
/sbin/chkconfig squid on
touch %_sysconfdir/squid/passwd
htpasswd2 -b %_sysconfdir/squid/passwd netpolice netpolice

%files
%_initdir/%name
%_unitdir/%name.service
%_sysconfdir/sysconfig/%name
%_sysconfdir/httpd2/conf/extra-start.d/030-host2cat.conf
%_sysconfdir/httpd2/conf/extra-available/host2cat.conf
%_sysconfdir/httpd2/conf/mods-start.d/030-host2cat.conf
%_sbindir/%name
%webserver_cgibindir/get_file.pl
%_libexecdir/%name
%config(noreplace) %webserver_cgibindir/config.ph
%webserver_cgibindir/*.cgi
%dir %attr(711,apache2,root) %_cachedir/%name
%attr(644,apache2,root) %_cachedir/%name/filter.db

%files -n squid-conf-%name
%config(noreplace) %_sysconfdir/squid/squid.conf.host2cat
%doc %_sysconfdir/squid/README.ALT.host2cat

%files -n openresolv-%name
%subscribers_dir/%name

%changelog
