Name: hermes
Version: 1.3.3
Release: alt5.qa1

Summary: Hermes pixel format conversion library
License: LGPL
Group: System/Libraries
Url: http://clanlib.org/hermes

Source: http://dark.x.dtu.dk/~mbn/clanlib/download/Hermes-%version.tar.bz2

Patch0: Hermes-1.3.3-64bit.patch
Patch1: Hermes-1.3.3-debian.patch

%def_disable static
%{?_enable_static:BuildPreReq: glibc-devel-static}

%description
HERMES is a library designed to convert a source buffer with a specified pixel
format to a destination buffer with possibly a different format at the maximum
possible speed.

%package -n lib%name
Summary: Hermes pixel format conversion library
Group: System/Libraries
Provides: %name = %version
Obsoletes: %name

%description -n lib%name
HERMES is a library designed to convert a source buffer with a specified pixel
format to a destination buffer with possibly a different format at the maximum
possible speed.

On x86 and MMX architectures, handwritten assembler routines are taking over
the job and doing it lightning fast.

On top of that, HERMES provides fast surface clearing, stretching and some
dithering. Supported platforms are basically all that have an ANSI C compiler
as there is no platform specific code but those are supported: DOS, Win32
(Visual C), Linux, FreeBSD (IRIX, Solaris are on hold at the moment), some BeOS
support.

%package -n lib%name-devel
Summary: Headers for developing programs that will use hermes.
Group: Development/C
Requires: lib%name = %version-%release
Provides: %name-devel = %version
Obsoletes: %name-devel

%description -n lib%name-devel
This package contains the headers that programmers will need to develop
applications which will use %name.

%package -n lib%name-devel-static
Summary: Static libraries for developing programs that will use hermes.
Group: Development/C
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
Static libraries for the %name

%prep
%setup -q -n Hermes-%version
%patch0 -p1
%patch1 -p1

%build
# Because of x86 assembler code, text relocations cannot be eliminated completely.
# As far as speed is first for this package, that's ok.
# Alternativelly, --disable-x86asm configure option can be used.
#set_verify_elf_method textrel=relaxed

%{?!_enable_static:export lt_cv_prog_cc_static_works=no}
%configure %{subst_enable static} --disable-x86asm
%make_build

%install
%makeinstall

%files -n lib%name
%doc AUTHORS TODO TODO.conversion
%_libdir/lib*.so.*

%files -n lib%name-devel
%doc docs/api/*.htm*
%_includedir/*
%_libdir/*.so

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%changelog
