%def_with pandoc
%define oname hddfancontrol

Name: hddfancontrol
Version: 1.6.2
Release: alt1

Summary: Control system fan speed by monitoring hard drive temperature

License: LGPLv3
Group: Monitoring
Url: https://github.com/desbma/hddfancontrol

# The PyPI archives don't have unit tests in them anymore.
Source: https://github.com/desbma/hddfancontrol/archive/%version/%oname-%version.tar

BuildArch: noarch

BuildRequires: python3-module-setuptools
BuildRequires: python3-devel
BuildRequires: python3-module-daemon, python3-module-docutils
BuildRequires: hddtemp, hdparm
BuildRequires: udev-rules
%if_with pandoc
BuildRequires: python3-module-pypandoc
%endif

Requires: python3-module-daemon
Requires: python3-module-docutils
Requires: python3-module-setuptools

Requires: hddtemp, hdparm

%description
HDD Fan control is a command line tool to dynamically control fan speed
according to hard drive temperature on Linux.

%prep
%setup -n %oname-%version

# Remove bundled egg-info
rm -rf %oname.egg-info

%build
%python3_build

%install
%python3_install

# Remove the "tests" directory that gets installed systemwide.
rm -rf %buildroot%python3_sitelibdir/tests

# Install the systemd script and config file.
mkdir -p %buildroot%_unitdir/
mkdir -p %buildroot%_sysconfdir/

sed 's,conf.d/hddfancontrol,hddfancontrol.conf,' -i systemd/hddfancontrol.service
cp -a systemd/hddfancontrol.service %buildroot%_unitdir/
cp -a systemd/hddfancontrol.conf %buildroot%_sysconfdir/

# Run the tests.
#check
#__python3 setup.py test

%files
%doc LICENSE
%doc README.md
%_bindir/hddfancontrol
%_unitdir/hddfancontrol.service
%config(noreplace) %_sysconfdir/hddfancontrol.conf
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version-py%_python3_version.egg-info

%changelog
