%def_without kde4
%def_without python2
%def_with ruby

Name: gwyddion
Version: 2.68
Release: alt1

Summary: An SPM data visualization and analysis tool
Summary(ru_RU.UTF-8):  Программа для визуализации и анализа данных АСМ

Group: Sciences/Other
License: GPLv2+
Url: http://gwyddion.net/

# Source-url: http://sourceforge.net/projects/gwyddion/files/gwyddion/%version/gwyddion-%version.tar.xz/download
Source: %name-%version.tar
Patch: ruby-dir.patch

BuildRequires(pre): rpm-build-intro rpm-build-python libGConf-devel

BuildRequires: GConf gcc-c++ libfftw3-devel libgtkglext-devel libgtksourceview-devel libicu-devel
BuildRequires: libxml2-devel
BuildRequires: libgtk+2-devel pkg-config chrpath libruby-devel
BuildRequires: libgomp-devel
BuildRequires: gtk-doc
%{?_with_python2:BuildRequires: python-module-distribute python-module-pygtk-devel}
%if_with ruby
BuildRequires(pre): rpm-build-ruby
BuildRequires: libruby-devel
%endif

# File Format and some features support
BuildRequires: libminizip-devel libwebp-devel openexr-devel libcfitsio-devel libunique-devel

BuildRequires: perl-podlators libpng-devel

BuildRequires: /proc

%{?_with_kde4:BuildRequires: kde4libs-devel}

%define _gtkdocdir %_datadir/gtk-doc/html
%define pkglibdir %_libdir/%name
%define pkglibexecdir %_libexecdir/%name
%define pkgdatadir %_datadir/%name
%define pkgincludedir %_includedir/%name
%define libname lib%{name}2
%if_with python2
%add_python_req_skip %pkglibdir
%add_python_req_skip %pkgdatadir
%endif

# Stop auto picking wrong deps!
%add_findreq_skiplist %pkglibexecdir/plugins/*


%package -n %libname
Summary: Libraries and tools for Gwyddion
Group: System/Libraries

%package -n lib%name-devel
Summary: Headers, libraries and tools for Gwyddion module development
Group: Development/C
Requires: %libname = %version-%release

%package -n lib%name-doc
Summary: Docs for Gwyddion module development
Group: Development/C
BuildArch: noarch

%package thumbnailer-kde4
Summary: KDE4 gwyddion thumbnailer module
Group: Graphical desktop/KDE
Requires: %name = %version-%release
# We do not actually link with them, but they own the module directory.
Requires: kde4libs >= 4.0

%package -n python-module-pygwy
Summary: Python tools for Gwyddion module development
Group: Development/Python
Requires: %libname = %version-%release


%description
Gwyddion is a modular SPM (Scanning Probe Microsopy) data visualization and
analysis tool written with Gtk+.

It can be used for all most frequently used data processing operations
including: leveling, false color plotting, shading, filtering, denoising, data
editing, integral transforms, grain analysis, profile extraction, fractal
analysis, and many more.  The program is primarily focused on SPM data analysis
(e.g. data obtained from AFM, STM, NSOM, and similar microscopes).  However, it
can also be used for analysis of SEM (Scanning Electron Microscopy) data or any
other 2D data.

%description -n %libname
Libraries for %name.

%description -n lib%name-devel
Header files, libraries and tools for Gwyddion module and plug-in development.
This package also contains sample plug-ins in various programming languages.

%description -n lib%name-doc
This package contains the API docmentation.

%description thumbnailer-kde4
Gwyddion-thumbnailer based KDE thumbnail creator extension module for SPM
files.

%description  -n python-module-pygwy
Python tools for Gwyddion module development

%if_with ruby
%package       -n ruby-%name
Summary:       Ruby bindings for %name dump script
Group:         Development/Ruby

%description   -n ruby-%name
Ruby bindings for %name dump script.
%endif


%prep
%setup
%autopatch

# Don't install .la files.
sed -i '/# Install the pseudo-library/,/^$/d' ltmain.sh
# Replace universal %%_bindir/env shbang with the real thing.
sed -i '1s/env *//' plugins/*.{py,rb,pl}

sed -i 's|#include <pygtk-2.0/pygobject.h>|#include <pygtk/pygobject.h>|' modules/pygwy/pygwy.c
sed -i 's|#include <pygtk-2.0/pygobject.h>|#include <pygtk/pygobject.h>|' modules/pygwy/gwy.c

# Fix libpython linking
sed -i 's|--ldflags|--libs|' m4/gwy-python.m4

%build
%autoreconf
%if_with kde4
%add_optflags -I%_K4includedir
%endif
%configure \
	CFLAGS='%optflags' CXXFLAGS='%optflags' \
	%{?_with_kde4:--with-kde4-thumbnailer} \
        %{?_without_ruby:--without-ruby} \
	--disable-rpath \
	--enable-library-bloat \
	--with-gl \
	--with-gtksourceview
%make_build

%install
%makeinstall_std
# Install the icon to the hicolor theme *and* to %%_pixmapsdir because
# some distros expect it in one place, some in another.
mkdir -p %buildroot%_pixmapsdir
install pixmaps/%name.png %buildroot%_pixmapsdir
%find_lang %name

# Get rid of .la files if some silly distros (hello Mandriva) overwrote our
# fixed libtool with some crap.
find %buildroot -name \*.la -print0 | xargs -0 rm -f

# Perl, Python, and Ruby modules are private, remove the Perl man page.
rm -f %buildroot%_man3dir/Gwyddion::dump.*

%if_with python2
mkdir -p %buildroot%python_sitelibdir
mv %buildroot%pkglibdir/modules/pygwy.so %buildroot%python_sitelibdir/gwy.so
%endif
%if_with ruby
install -D -m 755 plugins/invert_ruby.rb %buildroot%ruby_vendorlibdir/gwyddion/samples/invert_ruby.rb
install -D -m 755 plugins/invert_narray.rb %buildroot%ruby_vendorlibdir/gwyddion/samples/invert_narray.rb
%endif

%files -f %name.lang
%_bindir/%name
%_bindir/%name-thumbnailer

%doc AUTHORS COPYING INSTALL NEWS README THANKS
%dir %pkgdatadir
%dir %pkgdatadir/pixmaps
%pkgdatadir/pixmaps/*.png
%pkgdatadir/pixmaps/*.ico
%pkgdatadir/gradients/
%pkgdatadir/glmaterials/
%pkgdatadir/ui/
%pkgdatadir/user-guide-modules/
%_man1dir/%name.1*
%_man1dir/%name-thumbnailer.1*
%_liconsdir/%name.png
%_pixmapsdir/%name.png
%pkglibdir/modules/file/*.so
%pkglibdir/modules/graph/*.so
%pkglibdir/modules/layer/*.so
%pkglibdir/modules/process/*.so
%pkglibdir/modules/tool/*.so
%pkglibdir/modules/volume/*.so
%pkglibdir/modules/xyz/*.so
%pkglibdir/modules/cmap/*.so
%pkglibdir/modules/*.so
%dir %pkglibdir/modules/file
%dir %pkglibdir/modules/graph
%dir %pkglibdir/modules/layer
%dir %pkglibdir/modules/process
%dir %pkglibdir/modules/tool
%dir %pkglibdir/modules/volume
%dir %pkglibdir/modules/xyz
%dir %pkglibdir/modules/cmap
%dir %pkglibdir/modules
%dir %pkglibdir
%_desktopdir/%name.desktop
%_datadir/mime/packages/%name.xml
%dir %_datadir/thumbnailers
%_datadir/thumbnailers/%name.thumbnailer
%_datadir/metainfo/*.xml

%files -n %libname
%_libdir/*.so.*

%files -n lib%name-devel
%doc devel-docs/CODING-STANDARDS
%doc data/%name.vim
%pkgincludedir/app/*.h
%pkgincludedir/libdraw/*.h
%pkgincludedir/libprocess/*.h
%pkgincludedir/libgwyddion/*.h
%pkgincludedir/libgwydgets/*.h
%pkgincludedir/libgwymodule/*.h
%dir %pkgincludedir/app
%dir %pkgincludedir/libdraw
%dir %pkgincludedir/libprocess
%dir %pkgincludedir/libgwyddion
%dir %pkgincludedir/libgwydgets
%dir %pkgincludedir/libgwymodule
%dir %pkgincludedir
%_libdir/*.so
%_pkgconfigdir/gwyddion.pc
%pkglibdir/include/gwyconfig.h
%dir %pkglibdir/include
# Plug-ins and plug-in devel stuff
%pkglibdir/perl/Gwyddion/*
%dir %pkglibdir/perl/Gwyddion
%dir %pkglibdir/perl
%pkglibdir/python/Gwyddion/*
%dir %pkglibdir/python/Gwyddion
%dir %pkglibdir/python

%files -n lib%name-doc
# Documentation
%doc %_gtkdocdir/libgwyapp/*
%doc %_gtkdocdir/libgwydraw/*
%doc %_gtkdocdir/libgwyprocess/*
%doc %_gtkdocdir/libgwyddion/*
%doc %_gtkdocdir/libgwydgets/*
%doc %_gtkdocdir/libgwymodule/*
%doc %dir %_gtkdocdir/libgwyapp
%doc %dir %_gtkdocdir/libgwydraw
%doc %dir %_gtkdocdir/libgwyprocess
%doc %dir %_gtkdocdir/libgwyddion
%doc %dir %_gtkdocdir/libgwydgets
%doc %dir %_gtkdocdir/libgwymodule
%doc %dir %_gtkdocdir
%doc %dir %_datadir/gtk-doc
%doc %_docdir/%name/

%if_with kde4
%files thumbnailer-kde4
%_libdir/kde4/gwythumbcreator.so
%endif

%if_with python2
%files -n python-module-pygwy
%pkgdatadir/pygwy/
%python_sitelibdir/*
%_datadir/gtksourceview-2.0/language-specs/*.lang
%endif

%if_with ruby
%files -n ruby-%name
%ruby_vendorlibdir/gwyddion
%endif


%changelog
