%def_disable snapshot

%define ver_major 49
%define beta %nil
%define api_ver 3.0
%define xdg_name org.gnome.Gtranslator

%def_enable check

Name: gtranslator
Version: %ver_major.0
Release: alt1%beta

Summary: A GNOME po file editor with many bells and whistles.
License: GPL-3.0-or-later
Group: Development/Tools
Url: https://gitlab.gnome.org/GNOME/gtranslator

Vcs: https://gitlab.gnome.org/GNOME/gtranslator.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

Requires: libgda6-sqlite gettext-tools

%define gtk_ver 4.20
%define adw_ver 1.8
%define spell_ver 0.2.0
%define gtksourceview_api_ver 5
%define gtksourceview_ver 5.10.0
%define xml_ver 2.4.12
%define json_glib_ver 1.2.0

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson yelp-tools
BuildRequires: libgtk4-devel >= %gtk_ver
BuildRequires: pkgconfig(libadwaita-1) >= %adw_ver
BuildRequires: pkgconfig(sqlite3)
BuildRequires: libgtksourceview%gtksourceview_api_ver-devel >= %gtksourceview_ver
BuildRequires: libsoup3.0-devel gsettings-desktop-schemas-devel iso-codes-devel
BuildRequires: libspelling-devel >= %spell_ver libxml2-devel >= %xml_ver
BuildRequires: libjson-glib-devel >= %json_glib_ver
%{?_enable_check:BuildRequires: /usr/bin/appstreamcli desktop-file-utils}

%description
gtranslator is a quite comfortable gettext po/po.gz/(g)mo files editor
for the GNOME 3.x platform with many features. It's evolving quite fast
and many useful functions are already implemented; gtranslator aims to
be a very complete editing environment for translation issues within the
GNU gettext/GNOME desktop world.


%prep
%setup

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome %name

%check
%__meson_test

%files -f %name.lang
%_bindir/%name
%_datadir/%name/
%_datadir/gtksourceview-%gtksourceview_api_ver/language-specs/%name.lang
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/glib-2.0/schemas/*.xml
%_desktopdir/%xdg_name.desktop
%_iconsdir/hicolor/*/apps/%{xdg_name}*.svg
%_man1dir/%name.1*
%_datadir/metainfo/%xdg_name.appdata.xml
%doc AUTHORS NEWS README* THANKS


%changelog
