%def_disable snapshot
%define _libexecdir %_prefix/libexec

%define ver_base 3.12
%define ver_major 3.12
%define gst_api_ver 1.0
%define xdg_name org.gnome.gThumb

%def_enable libbrasero
%def_disable libchamplain
%def_enable clutter
%def_enable libraw
%def_enable libheif
%def_enable colord
%def_enable gstreamer
%ifarch armh
%def_disable libjxl
%else
%def_enable libjxl
%endif

Name: gthumb
Version: %ver_major.8.1
Release: alt1

Summary: An image file viewer and browser for GNOME
Summary(ru_RU.UTF-8): Просмотрщик изображений и фотоальбом для GNOME

License: GPL-2.0-or-later
Group: Graphics
Url: http://gthumb.sourceforge.net/

Vcs: https://gitlab.gnome.org/GNOME/gthumb.git

%if_enabled snapshot
Source: %name-%version.tar
%else
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%endif

%define glib_ver 2.38.0
%define gtk_ver 3.10.0
%define clutter_gtk_ver 1.0.0
%define gst_ver 1.0
%define exiv2_ver 0.20
%define libraw_ver 0.16
%define heif_ver 1.11
%define brasero_ver 3.2.0
%define soup_ver 2.42
%define gnome_common_ver 2.8.0
%define webp_ver 0.2.0
%define webkit_ver 2.6.0
%define champlain_ver 0.12.0
%define desktop_file_utils_ver 0.8
%define appstream_ver 0.14.6

Requires: %name-data = %EVR

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson intltool yelp-tools
BuildRequires: glib2-devel >= %glib_ver
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: libexiv2-devel >= %exiv2_ver gcc-c++
%{?_enable_clutter:BuildRequires: libclutter-devel libclutter-gtk3-devel >= %clutter_gtk_ver}
%{?_enable_gstreamer:BuildRequires: gstreamer%gst_api_ver-devel >= %gst_ver gst-plugins%gst_api_ver-devel >= %gst_ver}
BuildRequires: libjpeg-devel libpng-devel libtiff-devel zlib-devel librsvg-devel
BuildRequires: libwebp-devel >= %webp_ver libjson-glib-devel
BuildRequires: gsettings-desktop-schemas-devel
BuildRequires: libsoup-devel >= %soup_ver  pkgconfig(webkit2gtk-4.0) >= %webkit_ver
%{?_enable_libraw:BuildRequires: libraw-devel >= %libraw_ver libgomp-devel}
%{?_enable_libheif:BuildRequires: libheif-devel >= %heif_ver}
%{?_enable_libbrasero:BuildRequires: libbrasero-devel >= %brasero_ver}
%{?_enable_libchamplain:BuildRequires: libchamplain-gtk3-devel >= %champlain_ver}
%{?_enable_colord:BuildRequires: libcolord-devel}
%{?_enable_libjxl:BuildRequires: libjxl-devel}

BuildRequires: libjpeg-devel libtiff-devel libXrender-devel libXext-devel libX11-devel
BuildRequires: libXtst-devel libXxf86vm-devel libXi-devel
BuildRequires: libSM-devel libICE-devel

BuildRequires: desktop-file-utils >= %desktop_file_utils_ver
BuildRequires: gnome-common >= %gnome_common_ver
BuildRequires: libappstream-devel >= %appstream_ver  %_bindir/appstreamcli

%description
gThumb lets you browse your hard disk, showing thumbnails of image
files. It also lets view single files (including GIF animations),
add comments to images, organize images in catalogs, print images, view
slideshows, set desktop background, and more.

%description -l ru_RU.UTF-8
gThumb позволяет просматривать содержимое жёсткого диска, показывая
уменьшенные копии содержимого графических файлов. Также программа
позволяет просматривать отдельные изображения (включая мультфильмы в
формате GIF), добавлять комментарии к картинкам, раскладывать картинки
по каталогам, печатать, автоматически пролистывать серии картинок,
менять фон рабочего стола и многое другое.

%package data
Summary: Arch independent files for gThumb
Group: Graphics
BuildArch: noarch

%description data
This package provides noarch data needed for gThumb to work.

%package devel
Summary: gThumb development files
Group: Development/C
Requires: %name = %EVR

%description devel
This package contains headers needed to build extensions for gThumb.

%prep
%setup
sed -i 's/#include "rotation-utils.h"/&\n#include <stdbool.h>/' \
    extensions/image_rotation/rotation-utils.c

%build
%meson \
    -Dlibtiff=true \
    %{subst_enable_meson_bool libbrasero libbrasero} \
    %{subst_enable_meson_bool libchamplain libchamplain} \
    %{subst_enable_meson_bool libraw libraw} \
    %{subst_enable_meson_bool libheif libheif} \
    %{subst_enable_meson_bool colord colord} \
    %{subst_enable_meson_bool gstreamer gstreamer} \
    %{subst_enable_meson_bool clutter clutter} \
    %{subst_enable_meson_bool libjxl libjxl}
%nil
%meson_build

%install
%meson_install
%find_lang --with-gnome %name

%files
%_bindir/*
%dir %_libdir/%name/extensions
%_libdir/%name/extensions/*
%dir %_libexecdir/%name
%_libexecdir/%name/video-thumbnailer
%_desktopdir/*
%_datadir/metainfo/%xdg_name.metainfo.xml

%files data  -f %name.lang
%_datadir/%name/
%_iconsdir/hicolor/*/*/*
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.change-date.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.catalogs.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.comments.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.contact-sheet.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.convert-format.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.crop.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.enums.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.file-manager.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.gstreamer-tools.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.image-print.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.image-viewer.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.importer.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.photo-importer.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.pixbuf-savers.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.rename-series.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.resize.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.resize-images.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.rotate.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.slideshow.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.terminal.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gthumb.webalbums.gschema.xml
%_man1dir/gthumb.1.*
%doc AUTHORS NEWS README*

%files devel
%_includedir/%name/
%_datadir/aclocal/gthumb.m4
%_pkgconfigdir/*

%changelog
