%def_disable snapshot

%define ver_major 1.26
%define api_ver 1.6
%define gst_api_ver 1.0

%def_enable wayland
%def_disable doc
%def_disable check

Name: gstreamer-vaapi
Version: %ver_major.7
Release: alt1

Summary: GStreamer plugins to use VA-API video acceleration
Group: System/Libraries
License: LGPLv2.1
Url: http://gstreamer.freedesktop.org/modules/gstreamer-vaapi.html

%if_disabled snapshot
Source: http://gstreamer.freedesktop.org/src/%name/%name-%version.tar.xz
%else
Vcs: git://anongit.freedesktop.org/gstreamer/gstreamer-vaapi
Source: %name/%name-%version.tar
%endif

%define glib_ver 2.44
%define gst_ver %version
%define va_ver 1.1

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson glib2-devel >= %glib_ver libgtk+3-devel
BuildRequires: gst-plugins%gst_api_ver-devel >= %gst_ver
BuildRequires: gst-plugins-bad%gst_api_ver-devel >= %gst_ver
BuildRequires: libva-devel >= %va_ver
BuildRequires: libdrm-devel libudev-devel
BuildRequires: libGL-devel libXrandr-devel libXrender-devel
BuildRequires: libEGL-devel
%{?_enable_wayland:BuildRequires: wayland-devel libwayland-client-devel libwayland-server-devel wayland-protocols}
%{?_enable_doc:BuildRequires: hotdoc gstreamer%api_ver-utils}

%description
A collection of plugins and helper libraries to use VA-API video
acceleration from GStreamer applications.

Includes elements for video decoding, display, encoding and post-processing
using VA API (subject to hardware limitations).

%package devel-doc
Summary: Development documentation for %name
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
This package provides development documentation for the collection of
plugins and helper libraries to use VA-API video acceleration from
GStreamer applications.

%prep
%setup

%build
%meson \
	%{?_disable_doc:-Ddoc=disabled} \
	%{?_disable_wayland:-Dwayland=disabled}
%nil
%meson_build

%install
%meson_install

%check
%__meson_test -v

%files
%_libdir/gstreamer-%gst_api_ver/*.so
%doc AUTHORS NEWS README*

%if_enabled doc
%files devel-doc
%_datadir/gtk-doc/html/%name-plugins-%gst_api_ver/
%endif


%changelog
