%define _name gst-plugins
%define ver_major 1.26
%define api_ver 1.0

%define _gst_datadir %_datadir/gstreamer-%api_ver
%define _gst_libdir %_libdir/gstreamer-%api_ver
%define _gtk_docdir %_datadir/gtk-doc/html

%def_enable jack
%def_enable pulse
%def_enable caca
%def_enable qt5
%ifnarch armh
%def_enable qt6
%endif

%def_disable doc
%def_disable debugutils
%def_disable examples
%ifarch %ix86 x86_64 aarch64
%def_enable valgrind
%endif
%def_disable check

Name: %_name-good%api_ver
Version: %ver_major.7
Release: alt1

Summary: A set of GStreamer plugins considered good
Group: System/Libraries
License: LGPLv2+
Url: http://gstreamer.freedesktop.org/

Source: http://gstreamer.freedesktop.org/src/%_name-good/%_name-good-%version.tar.xz

Provides: %_name-good = %EVR
# https://bugzilla.altlinux.org/45382
Conflicts: gst-plugins-ugly%api_ver < 1.22.0

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson gcc-c++ orc nasm liborc-devel
BuildRequires: bzlib-devel gst-plugins%api_ver-devel >= %version
BuildRequires: libSM-devel libXdamage-devel libXext-devel libXfixes-devel
BuildRequires: libXv-devel libavc1394-devel libcairo-devel libdv-devel libflac-devel libiec61883-devel libjpeg-devel
BuildRequires: libshout2-devel libtag-devel libv4l-devel libwavpack-devel
BuildRequires: libsoup-devel
BuildRequires: libsoup3.0-devel
BuildRequires: libgdk-pixbuf-devel
BuildRequires: libpng-devel libcairo-gobject-devel libgudev-devel libspeex-devel zlib-devel libvpx-devel
BuildRequires: libmpg123-devel liblame-devel libtwolame-devel
BuildRequires: libgtk+3-devel
BuildRequires: liborc-test-devel
BuildRequires: pkgconfig(libxml-2.0)
%{?_enable_valgrind:BuildRequires: valgrind-tool-devel}
%{?_enable_jack:BuildRequires: libjack-devel}
%{?_enable_pulse:BuildRequires: libpulseaudio-devel}
%{?_enable_caca:BuildRequires: libcaca-devel}
%{?_enable_qt5:BuildRequires: qt5-base-devel qt5-tools qt5-declarative-devel qt5-x11extras-devel qt5-wayland-devel}
%{?_enable_qt6:BuildRequires: qt6-base-devel qt6-tools-devel qt6-declarative-devel qt6-wayland-devel /usr/bin/qsb-qt6}
%{?_enable_doc:BuildRequires: hotdoc gstreamer%api_ver-utils}
%{?_enable_check:BuildRequires: /proc gstreamer%api_ver %_bindir/gst-tester-%api_ver}

%description
GStreamer Good Plug-ins is is a set of plug-ins that the developers consider
to have good quality code, correct functionality, and their preferred license
(LGPL for the plug-in code, LGPL or LGPL-compatible for the supporting
library).

%package qt5
Summary: Qt5 plugin for GStreamer
Group: System/Libraries
Requires: gst-plugins-base%api_ver >= %version

%description qt5
This package contains Qt5 GL plugin for Gstreamer.

%package qt6
Summary: Qt6 plugin for GStreamer
Group: System/Libraries
Requires: gst-plugins-base%api_ver >= %version

%description qt6
This package contains Qt6 Qml plugin for Gstreamer.


%package devel-doc
Summary: Development documentation for GStreamer Good plugins
Group: Development/Documentation
BuildArch: noarch
Provides: %_name-good-devel-doc = %EVR

%description devel-doc
This package contains development documentation for GStreamer Good Plugins

%prep
%setup -n %_name-good-%version

%build
# required for gcc-14
%ifarch %ix86
%add_optflags -msse2
%endif
%meson \
    -Dexamples=disabled \
    %{subst_enable_meson_feature check tests} \
    %{subst_enable_meson_feature doc doc} \
    %{subst_enable_meson_feature debugutils debugutils}
%nil
%meson_build

%install
%meson_install
%find_lang %_name-good-%api_ver

%check
%__meson_test

%files -f %_name-good-%api_ver.lang
%_gst_libdir/*.so
%{?_enable_qt5:%exclude %_gst_libdir/libgstqmlgl.so}
%{?_enable_qt6:%exclude %_gst_libdir/libgstqml6.so}
%_gst_datadir/*
%doc AUTHORS NEWS README* RELEASE

%if_enabled qt5
%files qt5
%_gst_libdir/libgstqmlgl.so
%endif

%if_enabled qt6
%files qt6
%_gst_libdir/libgstqml6.so
%endif


%if_enabled doc
%files devel-doc
%_gtk_docdir/*
%endif

%changelog
