%define _unpackaged_files_terminate_build 1
%define efi_arches %ix86 x86_64 aarch64 riscv64 loongarch64

# SBAT generation number for ALT
# Refer to https://github.com/rhboot/shim/blob/main/SBAT.md
%global grub_gen_number 5
%global alt_gen_number 1

# grub modules' architecture is heavily dependent on custom ELF sections.
# LTO crashes that fragile house of cards, so should be disabled.
%global optflags_lto %nil

%global gnulib_version 9f48fb992a3d7e96610c4ce8be969cff2d61a01b

# No need for post-processing GRUB modules and their helpers
%add_findreq_skiplist %_libdir/grub/*/*
%add_verify_elf_skiplist %_libdir/grub/*/*
%add_debuginfo_skiplist %_libdir/grub/*/*
%add_python3_path %_libdir/grub
%add_python3_compile_exclude %_libdir/grub
%add_python3_req_skip %_libdir/grub/*/gdb_helper.py

Name: grub
Version: 2.12
Release: alt14

Summary: GRand Unified Bootloader
License: GPL-3
Group: System/Kernel and hardware

Url: http://www.gnu.org/software/grub

ExclusiveArch: %ix86 x86_64 aarch64 ppc64le riscv64 loongarch64

Source0: %name-%version.tar
Source1: grub2-sysconfig

Source2: gnulib-%version.tar

Source3: 39_memtest
Source4: grub.filetrigger

Source6: grub-autoupdate

Source8: update-grub
Source9: update-grub.8

Source10: grub-efi-autoupdate
Source11: embedded_grub.cfg

Source12: grub-entries
Source13: grub-entries.8

Source14: grub-efi.filetrigger

Source16: grub-dumpsbat.c

Source17: alt-ru.po

Patch0: %name-%version-alt.patch

BuildRequires(pre): rpm-macros-uefi
BuildRequires(pre): rpm-build-python3

BuildRequires: flex
BuildRequires: ruby
BuildRequires: autogen
BuildRequires: texinfo
BuildRequires: help2man
BuildRequires: squashfs-tools

BuildRequires: zlib-devel
BuildRequires: libfuse-devel
BuildRequires: liblzma-devel
BuildRequires: libfreetype-devel
BuildRequires: libdevmapper-devel

BuildRequires: fonts-bitmap-misc
BuildRequires: fonts-bitmap-univga
# Default font
%define font /usr/share/fonts/bitmap/univga/u_vga16_9.pcf.gz

Requires: gettext

%ifarch %ix86
%global grubefiarch i386-efi
%global linux_module_name linux
%global efi_suff ia32
%endif
%ifarch x86_64
%global grubefiarch x86_64-efi
%global linux_module_name linux
%global efi_suff x64
%endif
%ifarch aarch64
%global grubefiarch arm64-efi
%global linux_module_name linux
%global efi_suff aa64
%endif
%ifarch riscv64
%global grubefiarch riscv64-efi
%global linux_module_name linux
%global efi_suff riscv64
%endif
%ifarch loongarch64
%global grubefiarch loongarch64-efi
%global linux_module_name linux
%global efi_suff loongarch64
%endif


%package common
Summary: GRand Unified Bootloader (common part)
Group: System/Kernel and hardware
Provides: grub2-common = %EVR
Obsoletes: grub2-common < %EVR

%package pc
Summary: GRand Unified Bootloader (PC BIOS variant)
Group: System/Kernel and hardware
Requires: %name-common = %version-%release
%ifarch %ix86 x86_64
Provides: grub2 = %EVR
Provides: grub = %EVR
%endif
Provides: grub2-pc = %EVR
Obsoletes: grub2-pc < %EVR

%package ieee1275
Summary: GRand Unified Bootloader (IEEE1275 variant)
Group: System/Kernel and hardware
Requires: %name-common = %version-%release
%ifarch ppc64le
Requires: powerpc-utils
Provides: grub2 = %EVR
Provides: grub = %EVR
%endif

%package efi
Summary: GRand Unified Bootloader (UEFI variant)
Group: System/Kernel and hardware
Requires: %name-common = %EVR
Provides: grub2-efi = %EVR
Obsoletes: grub2-efi < %EVR
Requires(pre): efibootmgr >= 15
%ifarch aarch64 loongarch64 riscv64
Provides: grub2 = %EVR
Provides: grub = %EVR
%endif

%package efi-checkinstall
Summary: Verify EFI-stub signature
Group: System/Kernel and hardware
Requires: %name-efi = %EVR
Requires(post): rpm-pesign-checkinstall

%define desc_generic \
GNU GRUB is a multiboot boot loader. It was derived from GRUB. It is an \
attempt to produce a boot loader for IBM PC-compatible machines that \
has both the ability to be friendly to beginning or otherwise \
nontechnically interested users and the flexibility to help experts in \
diverse environments. It is compatible with Free/Net/OpenBSD and Linux. \
It supports Win 9x/NT and OS/2 via chainloaders. It has a menu \
interface and a command line interface. \
It implements the Multiboot standard, which allows for flexible loading \
of multiple boot images (needed for modular kernels such as the GNU Hurd).

%description
%desc_generic

%description common
%desc_generic

This package carries the shared code and data.

%description pc
%desc_generic

This package provides PC BIOS support.

%description ieee1275
%desc_generic

This package provides Open Firmware (IEEE 1275) support.

%description efi
%desc_generic

This package provides UEFI systems support.

Please note that the official build is signed; this shouldn't
intervene in any way but rather provides means to cope with
UEFI SecureBoot (better described as Restricted Boot) firmware
when one can't disable it easily, doesn't want to, or needs not to.

%description efi-checkinstall
%desc_generic

This package enables EFI signature verification.

%prep
%setup -a 2

%patch0 -p1

sed -i "/^AC_INIT(\[GRUB\]/ s/%version[^]]\+/%version-%release/" configure.ac

# Create sbat.csv file for ALT Linux grub image
cat > sbat.csv <<EOF
sbat,1,SBAT Version,sbat,1,https://github.com/rhboot/shim/blob/main/SBAT.md
grub,%grub_gen_number,Free Software Foundation,grub,%version,https://www.gnu.org/software/grub/
grub.altlinux,%alt_gen_number,ALT Linux,grub,%version-%release,https://git.altlinux.org/gears/g/grub.git
EOF

# Check gnulib version
grep '^GNULIB_REVISION=%gnulib_version$' bootstrap.conf || exit 1

# Append ALT-specific translations to ru.po
cat %SOURCE17 >> po/ru.po

# autogen.sh script searches for *.in files under ./util to create
# po/POTFILES-shell.in which is used to update po files
sed -n -e 's/\$/\\\$/' -e 's/^msgid /gettext_printf /p' %SOURCE17 > util/alt-l18n-strings.in

%build
./bootstrap --no-git --gnulib-srcdir=./gnulib
build_grub() {
	local dir="$1"; shift
	mkdir -p "$dir"
	pushd "$dir"
	%define _configure_script ../configure
	%configure \
		TARGET_LDFLAGS=-static \
		--disable-werror \
		"$@"
	%make_build
	popd
}

build_efi_image() {
	local mkimage="$1"; shift
	local dir="$1"; shift
	local format="$1"; shift
	"$mkimage" -O "$format" -o "$dir"/grub.efi -d "$dir"/grub-core \
		-m memdisk.squashfs -p "" --sbat sbat.csv \
		part_gpt part_apple part_msdos hfsplus fat ext2 btrfs xfs \
		squash4 normal chain boot configfile diskfilter \
		minicmd reboot halt search search_fs_uuid search_fs_file \
		search_label sleep test syslinuxcfg all_video video font \
		gfxmenu gfxterm gfxterm_background lvm lsefi efifwsetup cat \
		gzio iso9660 loadenv loopback mdraid09 mdraid1x png jpeg \
		extcmd keystatus procfs cryptodisk gcry_rijndael gcry_sha1 \
		gcry_sha256 luks luks2 gcry_sha512 gcry_serpent gcry_twofish \
		crypto pbkdf2 password_pbkdf2 echo regexp tftp \
		f2fs exfat ntfs ntfscomp memdisk raid5rec \
		"$@"
}

%ifarch %ix86 x86_64
# NB: not a fashion but the critical need to fit into 62 sectors.
export CFLAGS="%optflags -Os"
export CXXFLAGS="%optflags -Os"

build_grub build-pc \
	--with-platform=pc \
#

unset CFLAGS
unset CXXFLAGS
%endif

%ifarch ppc64le
build_grub build-ieee1275 \
	--with-platform=ieee1275 \
#
%endif

%ifarch %efi_arches
build_grub build-efi \
	--with-platform=efi \
#

# create memdisk with fonts
workdir="$(mktemp -d)"
mkdir -p "$workdir/fonts"
./build-efi/grub-mkfont -o "$workdir/fonts/unicode.pf2" %font
mksquashfs "$workdir" memdisk.squashfs -comp xz
rm -rf "$workdir"

build_efi_image build-efi/grub-mkimage build-efi %grubefiarch %linux_module_name

#add forced ia32 version build to be bundled with x86_64 EFI
%ifarch x86_64
build_grub build-efi-ia32 \
	--with-platform=efi \
	--target=i386 \
#
# use 64bit mkimage to build i386-efi image
build_efi_image build-efi/grub-mkimage build-efi-ia32 i386-efi linux
%endif
%endif

# build grub-dumpsbat utility used in grub-efi-autoupdate
gcc %optflags -D_FILE_OFFSET_BITS=64 %SOURCE16 -o grub-dumpsbat

%install
%ifarch %ix86 x86_64
%makeinstall_std -C build-pc
%ifarch x86_64
#"cherry pick" only i386 executable
install -pDm644 build-efi-ia32/grub.efi %buildroot%_efi_bindir/grubia32.efi

#install ia32 version in parallel with x64 for x86_64 platforms with ia32 EFI
%makeinstall_std -C build-efi-ia32
%endif
%endif

%makeinstall_std -C \
%ifarch ppc64le
	build-ieee1275
%else
	build-efi
%endif

install -pDm644 %SOURCE1 %buildroot%_sysconfdir/sysconfig/grub2

%find_lang grub

mkdir -p %buildroot/boot/grub/fonts

install -pD -m755 %SOURCE8 %buildroot%_sbindir/
install -pD -m644 %SOURCE9 %buildroot%_man8dir/update-grub.8
install -pD -m644 %SOURCE13 %buildroot%_man8dir/grub-entries.8

# TODO: drop the obsolete one (unifont.pf2)
%buildroot%_bindir/grub-mkfont -o %buildroot/boot/grub/unifont.pf2 \
                               %_datadir/fonts/bitmap/misc/8x13.pcf.gz
%buildroot%_bindir/grub-mkfont -o %buildroot/boot/grub/fonts/unicode.pf2 %font
install -pDm644 %buildroot/boot/grub/fonts/unicode.pf2 \
        %buildroot%_datadir/grub/unicode.pf2

mkdir -p %buildroot/boot/grub/themes

install -pDm755 %SOURCE3 %buildroot%_sysconfdir/grub.d/
sed -i 's,^libdir=,libdir=%_libdir,g' %buildroot%_sysconfdir/grub.d/39_memtest
sed -i 's,@LOCALEDIR@,%_datadir/locale,g' %buildroot%_sysconfdir/grub.d/*

install -pDm755 %SOURCE4 %buildroot%_rpmlibdir/grub.filetrigger
%ifarch %ix86 x86_64 ppc64le
install -pDm755 %SOURCE6 %buildroot%_sbindir/grub-autoupdate
%endif

%ifarch %efi_arches
install -pDm755 %SOURCE10 %buildroot%_sbindir/grub-efi-autoupdate
install -pDm755 %SOURCE14 %buildroot%_rpmlibdir/grub-efi.filetrigger
install -pDm644 sbat.csv %buildroot%_datadir/grub/sbat.csv
%endif
install -pDm755 %SOURCE12 %buildroot%_sbindir/grub-entries

# install grub-dumpsbat utility used in grub-efi-autoupdate
install -pDm755 grub-dumpsbat %buildroot%_bindir/grub-dumpsbat

# Ghost config file
install -d %buildroot/boot/grub
touch %buildroot/boot/grub/grub.cfg
ln -s ../boot/grub/grub.cfg %buildroot%_sysconfdir/grub.cfg

# Docs/habits compat symlink
mkdir -p %buildroot%_sysconfdir/default
ln -s ../sysconfig/grub2 %buildroot%_sysconfdir/default/grub

# Ghost file generated by grub-install
touch %buildroot/boot/grub/grubenv

# These tools are only for efi and x86_64
%ifnarch x86_64
rm -vf %buildroot%_bindir/grub-render-label
rm -vf %buildroot%_sbindir/grub-bios-setup
rm -vf %buildroot%_sbindir/grub-macbless

rm -vf %buildroot%_man1dir/grub-render-label*
rm -vf %buildroot%_man8dir/grub-bios-setup*
rm -vf %buildroot%_man8dir/grub-macbless*
%endif

%ifarch %efi_arches
install -pDm644 build-efi/grub.efi %buildroot%_efi_bindir/grub%{efi_suff}.efi

# Remove headers
rm -f %buildroot%_libdir/grub-efi/*/*.h
%endif

%files common -f grub.lang
%dir %_sysconfdir/grub.d
%dir %_datadir/grub
%dir %_libdir/grub
%dir /boot/grub
/boot/grub/*.pf2
/boot/grub/fonts/
/boot/grub/themes/
%_sysconfdir/grub.d/00_header
%_sysconfdir/grub.d/05_altlinux_theme
%_sysconfdir/grub.d/10_linux
%_sysconfdir/grub.d/20_linux_xen
%_sysconfdir/grub.d/25_bli
%_sysconfdir/grub.d/30_os-prober
%_sysconfdir/grub.d/30_uefi-firmware
%_sysconfdir/grub.d/39_memtest
%config(noreplace) %_sysconfdir/grub.d/40_custom
%config(noreplace) %_sysconfdir/grub.d/41_custom
%_sysconfdir/grub.d/README
%config(noreplace) %_sysconfdir/sysconfig/grub2
%ghost %config(noreplace) /boot/grub/grub.cfg
%ghost %attr(644,root,root) /boot/grub/grubenv
%_sysconfdir/grub.cfg
%_sysconfdir/default/grub
%_datadir/bash-completion/completions/*
%_rpmlibdir/grub.filetrigger
# these tools are only for efi and x86_64
%ifarch x86_64
%_bindir/grub-render-label
%_sbindir/grub-bios-setup
%_sbindir/grub-macbless
%endif
%_sbindir/grub-install
%_sbindir/grub-mkconfig
%_sbindir/grub-ofpathname
%_sbindir/grub-probe
%_sbindir/grub-reboot
%_sbindir/grub-set-default
%_sbindir/grub-sparc64-setup
%_sbindir/grub-entries
%_sbindir/update-grub
%_bindir/grub-editenv
%_bindir/grub-file
%_bindir/grub-fstest
%_bindir/grub-glue-efi
%_bindir/grub-kbdcomp
%_bindir/grub-menulst2cfg
%_bindir/grub-mknetdir
%_bindir/grub-mkstandalone
%_bindir/grub-mkfont
%_bindir/grub-mklayout
%_bindir/grub-mkimage
%_bindir/grub-mkpasswd-pbkdf2
%_bindir/grub-mkrelpath
%_bindir/grub-mkrescue
%_bindir/grub-mount
%_bindir/grub-script-check
%_bindir/grub-syslinux2cfg
%_bindir/grub-dumpsbat
%_datadir/grub/grub-mkconfig_lib
%_datadir/grub/unicode.pf2
%_man1dir/*
%_man8dir/*
%_infodir/grub.info.*
%_infodir/grub-dev.info.*

%ifarch %ix86 x86_64
%files pc
%_sbindir/grub-autoupdate
%_libdir/grub/*-pc/
%endif

%ifarch ppc64le
%files ieee1275
%_sbindir/grub-autoupdate
%_libdir/grub/*-ieee1275/
%endif

%ifarch %efi_arches
%files efi
%_efi_bindir/grub%{efi_suff}.efi
%ifarch x86_64
%_efi_bindir/grubia32.efi
%_libdir/grub/i386-efi
%endif
%_sbindir/grub-efi-autoupdate
%_libdir/grub/%grubefiarch
%_rpmlibdir/grub-efi.filetrigger
%_datadir/grub/sbat.csv

%files efi-checkinstall
%endif

%ifarch %ix86 x86_64 ppc64le
%ifarch %ix86 x86_64
%post pc
%endif
%ifarch ppc64le
%post ieee1275
%endif
grub-autoupdate || {
	echo "** WARNING: grub-autoupdate failed, NEXT BOOT WILL LIKELY FAIL NOW"
	echo "** WARNING: please run it by hand, record the output offline,"
	echo "** WARNING: make sure you have bootable rescue CD/flash media handy"
	echo "** WARNING: and try \`grub-install /dev/sdX' manually"
} >&2
%endif

%post efi
[ -z "$DURING_INSTALL" ] || exit 0
modprobe -q efivars ||:
modprobe -q efivarfs ||:
grep -q '^GRUB_DISTRIBUTOR=' %_sysconfdir/sysconfig/grub2 ||
	echo 'GRUB_DISTRIBUTOR="ALT Linux"' >> %_sysconfdir/sysconfig/grub2

grep -q '^GRUB_BOOTLOADER_ID=' %_sysconfdir/sysconfig/grub2 ||
	echo 'GRUB_BOOTLOADER_ID="altlinux"' >> %_sysconfdir/sysconfig/grub2

grub-efi-autoupdate || {
	echo "** WARNING: grub-efi-autoupdate failed, NEXT BOOT WILL LIKELY FAIL NOW"
	echo "** WARNING: please run grub-efi-autoupdate by hand, record the output offline,"
	echo "** WARNING: make sure you have recovery bootable media handy."
} >&2

%changelog
