%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
# LFS cannot be used due to hooks.
%set_verify_elf_method strict,lfs=relaxed,lint=relaxed

Name: gperftools
Version: 2.17.2
Release: alt1

Provides: google-perftools

Summary: Performance tools for C++ (pprof)
Group: Development/C++
Url: https://github.com/gperftools/gperftools
License: BSD-3-Clause

Source: %name-%version.tar.gz

BuildRequires: gcc-c++
BuildRequires: libunwind-devel
%{?!_without_check:%{?!_disable_check:
BuildRequires: /proc
}}

%description
gperftools is a collection of a high-performance multi-threaded
malloc() implementation, plus some pretty nifty performance analysis
tools.

%package -n lib%name
Summary: Performance tools for C++ (tcmalloc) - shared libraries
Group: System/Libraries
Provides: libgoogle-perftools

%description -n lib%name
The lib%name package is part of %name. It contains shared libraries
for analize the performance of C++ programs.

%package -n lib%name-devel
Summary: Performance tools for C++ (tcmalloc)
Group: Development/C++
Requires: lib%name = %EVR
Provides: %name-devel = %EVR

%description -n lib%name-devel
The lib%name-devel package contains static and debug libraries and header
files for developing applications that use the %name package.

%prep
%setup

%build
%define optflags_lto %nil
%autoreconf
%configure --disable-static
%make_build

%install
%make_install DESTDIR=%buildroot install

%check
# https://github.com/gperftools/gperftools/issues/1557
%make_build check VERBOSE=1 ||
%make_build recheck VERBOSE=1 ||
%make_build recheck VERBOSE=1

%files -n lib%name
%_libdir/lib*.so.*

%files -n lib%name-devel
%doc %_defaultdocdir/%name
%_includedir/%name
%_libdir/lib*.so
%_pkgconfigdir/*.pc

%changelog
