Name: gource
Version: 0.55
Release: alt1

Summary: OpenGL-based 3D visualisation tool for source control repositories
License: GPL-3.0-only
Group: Development/Tools

Url: http://gource.io/
# git clone https://github.com/acaudwell/Gource.git
# git clone https://github.com/acaudwell/Core.git
Source0: %name-main-%version.tar
Source1: %name-core-%version.tar
Patch3500: %name-ax_boost_base.patch

Requires: fonts-ttf-freefont

BuildPreReq: libSDL2-devel >= 1.2
BuildPreReq: libSDL2_image-devel >= 1.2
BuildPreReq: libpcre2-devel
BuildPreReq: libfreetype-devel
BuildPreReq: libglew-devel
BuildPreReq: libglm-devel >= 0.9.3
BuildPreReq: boost-filesystem-devel >= 1.46
BuildPreReq: tinyxml-devel
BuildPreReq: gcc-c++
# zlib-devel be req by libfreetype
BuildPreReq: zlib-devel

BuildRequires: libpng-devel

%define _unpackaged_files_terminate_build 1

%description
OpenGL-based 3D visualisation tool for source control repositories. The
repository is displayed as a tree where the root of the repository is
the centre, directories are branches and files are leaves. Contributors
to the source code appear and disappear as they contribute to specific
files and directories.

%prep
%setup
tar xf %_sourcedir/%name-core-%version.tar -C src/
%patch3500 -p1

%build
%autoreconf
%configure --with-tinyxml --with-x
%make_build

%install
%makeinstall_std

%files
%_bindir/*
%_datadir/%name/
%_man1dir/*

%changelog
