Name: googletest
Version: 1.17.0
Release: alt1

Summary: Google's framework for writing C++ tests
License: BSD-3-Clause
Group: Development/C++

Url: https://github.com/google/%name

# https://github.com/google/%name/archive/v%version/%name-%version.tar.gz
Source: %name-%version.tar

BuildRequires: cmake
BuildRequires: ctest
BuildRequires: gcc-c++

%description
Google's framework for writing C++ tests on a variety of platforms
(Linux, Mac OS X, Windows, Cygwin, Windows CE, and Symbian). Based on
the xUnit architecture. Supports automatic test discovery, a rich set of
assertions, user-defined assertions, death tests, fatal and non-fatal
failures, value- and type-parameterized tests, various options for
running the tests, and XML test report generation.

%package -n libgtest
Summary: Google's framework for writing C++ tests
Group: Development/C++
Provides: libgtest0
Obsoletes: libgtest0 <= 1.10.0 

%description -n libgtest
Google's framework for writing C++ tests on a variety of platforms
(Linux, Mac OS X, Windows, Cygwin, Windows CE, and Symbian). Based on
the xUnit architecture. Supports automatic test discovery, a rich set of
assertions, user-defined assertions, death tests, fatal and non-fatal
failures, value- and type-parameterized tests, various options for
running the tests, and XML test report generation.

%package -n libgtest-devel
Summary: Development environment for gtest
Group: Development/C++
Requires: libgmock-devel = %EVR

%description -n libgtest-devel
Development environment for gtest

%package -n libgmock
Summary: Google C++ Mocking Framework
Group: Development/C++
Provides: libgmock0
Obsoletes: libgmock0 <= 1.10.0

%description -n libgmock
Google's framework for writing and using C++ mock classes on a variety
of platforms (Linux, Mac OS X, Windows, Windows CE, Symbian, etc).
Inspired by jMock, EasyMock, and Hamcrest, and designed with C++'s
specifics in mind, it can help you derive better designs of your
system and write better tests.

%package -n libgmock-devel
Summary: Development environment for gmock
Group: Development/C++

%description -n libgmock-devel
Development environment for gmock

%prep
%setup

%build
%ifarch %e2k
# googletest/src/gtest.cc:2806 wrt testing::<unnamed>::TestNameIs::operator()
%add_optflags -Wno-error=unused-function
# error: unrecognized argument to attribute "optimize"
sed -i 's/__attribute__((optimize("no-optimize-sibling-calls")))//' \
	googletest/include/gtest/internal/gtest-port.h
%endif
%cmake \
  -DBUILD_SHARED_LIBS:BOOL=TRUE \
  -Dgmock_build_tests:BOOL=TRUE \
  -DCMAKE_CXX_STANDARD=17
%cmake_build

%install
%cmake_install

%check
%ctest || :

%files -n libgtest
%doc CONTRIBUTORS LICENSE googletest/README.md
%_libdir/libgtest.so.*
%_libdir/libgtest_main.so.*

%files -n libgtest-devel
%_libdir/libgtest.so
%_libdir/libgtest_main.so
%_libdir/cmake/GTest
%_pkgconfigdir/gtest.pc
%_pkgconfigdir/gtest_main.pc
%_includedir/gtest

%files -n libgmock
%doc CONTRIBUTORS LICENSE googlemock/README.md
%_libdir/libgmock.so.*
%_libdir/libgmock_main.so.*

%files -n libgmock-devel
%_libdir/libgmock.so
%_libdir/libgmock_main.so
%_pkgconfigdir/gmock.pc
%_pkgconfigdir/gmock_main.pc
%_includedir/gmock

%changelog
