%define ver_major 6.0
%def_with emacs

Name: gnuplot
Epoch: 1
Version: 6.0.3
Release: alt1

Summary: A program for plotting mathematical expressions and data
Summary(ru_RU.UTF-8): Программа для построения графиков математических выражений и данных

License: gnuplot and MIT
Group: Sciences/Mathematics
URL: http://www.gnuplot.info
VCS: https://git.code.sf.net/p/gnuplot/gnuplot-main

Source: %name-%version.tar

Source3: %name.desktop
Source4: %name.menu

Source10: %name.16.png
Source11: %name.32.png
Source12: %name.48.png

Source14: gnuplot-emacs.el

Patch1: gnuplot-6.0.0-debian-no-picins.patch
# these from fedora
Patch2: gnuplot-4.2.0-fonts.patch
Patch4: gnuplot-5.2.2-doc.patch
# ALT 34350
Patch6: gnuplot-5.4.0-fix-help.patch

Patch7: gnuplot-5.4.4-add_russian_translation.patch
Patch8: gnuplot-6.0.2-alt-workaround-for-demo-make.patch

BuildRequires(pre): rpm-build-tex
BuildRequires: gcc-c++ libcerf-devel libgd3-devel libreadline-devel libncurses-devel
BuildRequires: libopenspecfun-devel
%{?_with_emacs:BuildRequires: emacs-common}

# for docs
BuildRequires: /usr/bin/pdflatex texlive-texmf
# for wxt terminal
BuildRequires: libcairo-devel libpango-devel libwxGTK3.2-devel
# for qt terminal
BuildRequires: qt6-base-devel qt6-svg-devel qt6-5compat-devel qt6-tools
# for lua/TikZ
BuildRequires: lua-devel

Requires(post,postun): desktop-file-utils
Requires: fonts-ttf-dejavu
Requires: %name-common-x11 = %EVR

%package common
Group: Sciences/Mathematics
Summary: The common gnuplot parts
BuildArch: noarch
Conflicts: %name < %EVR

%package common-x11
Group: Sciences/Mathematics
Summary: The common-x11 gnuplot parts
Requires: %name-common = %EVR
Conflicts: %name < %EVR

%package minimal
Group: Sciences/Mathematics
Summary: Minimal version of program for plotting mathematical expressions and data
Requires: %name-common = %EVR

%package qt
Group: Sciences/Mathematics
Summary: Qt interface for gnuplot
Requires: %name-common-x11 = %EVR

%package doc
Group: Documentation
Summary: Documentation of bindings for the gnuplot main application
BuildArch: noarch

%package demo
Group: Sciences/Mathematics
Summary: Demo gnuplot applications
BuildArch: noarch

%description
Gnuplot is a command-line driven, interactive function plotting program
especially suited for scientific data representation. Gnuplot can be used to
plot functions and data points in both two and three dimensions and in many
different formats.

Install gnuplot if you need a graphics package for scientific data
representation.

%description -l ru_RU.UTF-8
Gnuplot это интерактивная программа, предназначенная для построения
графиков.  Она особенно хорошо подходит для представления научных 
данных.  Gnuplot может строить 2-х и 3-х мерные графики функций 
и числовых данных во множестве различных графических форматов.

%description common
Gnuplot is a command-line driven, interactive function plotting
program especially suited for scientific data representation.  Gnuplot
can be used to plot functions and data points in both two and three
dimensions and in many different formats.

This subpackage contains common parts needed for arbitrary version of gnuplot

%description common-x11
Gnuplot is a command-line driven, interactive function plotting
program especially suited for scientific data representation.  Gnuplot
can be used to plot functions and data points in both two and three
dimensions and in many different formats.

This subpackage contains common-x11 parts needed for arbitrary version of gnuplot

%description minimal
Gnuplot is a command-line driven, interactive function plotting
program especially suited for scientific data representation.  Gnuplot
can be used to plot functions and data points in both two and three
dimensions and in many different formats.


%description qt
Gnuplot is a command-line driven, interactive function plotting
program especially suited for scientific data representation.  Gnuplot
can be used to plot functions and data points in both two and three
dimensions and in many different formats.

This package provides a Qt based terminal version of gnuplot

%description doc
The gnuplot-doc package contains the documentation related to gnuplot
plotting tool

%description demo
The gnuplot-demo package contains the demo applications related to gnuplot
plotting tool

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch4 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1

%build
%ifarch %e2k
# Qt6 requirement
export CXXFLAGS+=-std=c++17
%endif

%define configure_opts --with-readline=gnu --enable-history-file --without-row-help --with-texdir=%_texmfmain/%name --with-lua --with-gihdir=%name/%ver_major

sh prepare
%autoreconf

# at first create minimal version of gnuplot for server SIG purposes
mkdir minimal
cd minimal
ln -s ../configure .
%configure %configure_opts --disable-wxwidgets --without-cairo --without-qt --without-x
%make_build
cd -

# create full version of gnuplot
mkdir wx
cd wx
ln -s ../configure .
%configure %configure_opts --without-qt
%make_build
cd -

mkdir qt
cd qt
ln -s ../configure .
%configure %configure_opts --disable-wxwidgets
%make_build
cd -

# Docs don't build properly out of tree
%configure  %configure_opts
ln -s ../wx/src/gnuplot src/
export PERL5LIB=$(pwd)/docs:$(pwd)/docs/htmldocs
ln -s ../VERSION docs/VERSION
%make_build -C docs allterm-ja.h
%make_build -C docs pdf
export GNUPLOT_PS_DIR=../../term/PostScript
%make_build -C docs/psdoc ps_symbols.ps ps_fontfile_doc.pdf
%make_build -C docs gih

%install
# install wx
%makeinstall_std -C wx
# rename binary
mv %buildroot%_bindir/%name %buildroot%_bindir/%name-wx

# install qt
%makeinstall_std -C qt
# rename binary
mv %buildroot%_bindir/%name %buildroot%_bindir/%name-qt

# install minimal binary
install -p -m 755 minimal/src/%name %buildroot%_bindir/%name-minimal

# install docs
%makeinstall_std -C docs

# Add alternatives for gnuplot
mkdir -p %buildroot%_altdir
printf '%_bindir/%name\t%_bindir/gnuplot-minimal\t10\n' > %buildroot%_altdir/%name-minimal
printf '%_bindir/%name\t%_bindir/gnuplot-wx\t20\n' > %buildroot%_altdir/%name-wx
printf '%_bindir/%name\t%_bindir/gnuplot-qt\t30\n' > %buildroot%_altdir/%name-qt

# menus
install -D -pm644 %SOURCE3  %buildroot%_desktopdir/%name.desktop

# icon
install -D -pm644 %SOURCE10  %buildroot/%_miconsdir/%name.png
install -D -pm644 %SOURCE11  %buildroot/%_niconsdir/%name.png
install -D -pm644 %SOURCE12  %buildroot/%_liconsdir/%name.png

# help data
cp docs/%{name}.gih %buildroot%_datadir/%name/%ver_major/

# cleanup before add to doc
rm -v demo/Makefile*
rm -v demo/html/Makefile*

%files
%_bindir/gnuplot-wx
%_altdir/%name-wx

%files common
%_mandir/man?/*
%_datadir/%name
%exclude %_datadir/%name/%ver_major/qt
%_desktopdir/*
%_niconsdir/*.png
%_miconsdir/*.png
%_liconsdir/*.png
%_texmfmain/%name
%dir %_libexecdir/%name
%dir %_libexecdir/%name/%ver_major

%files common-x11
%_libexecdir/%name/%ver_major/%{name}_x11

%files minimal
%_bindir/gnuplot-minimal
%_altdir/%name-minimal

%files qt
%_bindir/%name-qt
%_altdir/%name-qt
%_libexecdir/%name/%ver_major/%{name}_qt
%_datadir/%name/%ver_major/qt

%files doc
%doc Copyright BUGS README NEWS RELEASE_NOTES
%doc docs/psdoc/ps_* docs/gnuplot.pdf

%files demo
%doc demo

%changelog
