%def_enable snapshot
%define _unpackaged_files_terminate_build 1

%define ver_major 1.12
%define api_ver 1.12
%define goffice_api_ver 0.10
%define rdn_name org.gnumeric.gnumeric

%def_without gda
%def_with python
%def_with perl
%def_enable introspection
%def_disable check

Name: gnumeric
Version: %ver_major.59
Release: alt1

Summary: A full-featured spreadsheet for GNOME
License: GPL-2.0 or GPL-3.0
Group: Office
Url: http://www.gnumeric.org/

Vcs: https://gitlab.gnome.org/GNOME/gnumeric.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif
Patch: gnumeric-1.12.56-alt-desktop.patch

Patch10: gnumeric-1.12.59-up-HEAD.patch

Obsoletes: %name-light
Provides: %name-light = %EVR

%define gsf_ver 1.14.51
%define gda_ver 5.2
%define desktop_file_utils_ver 0.10
%define goffice_ver 0.10.57

%{?_with_python:
%add_python3_path %_libdir/%name/%version/plugins
# Provided by python_loader.so
Provides: python3(Gnumeric)}

Requires(post,postun): desktop-file-utils >= %desktop_file_utils_ver
Requires: libgnomeoffice%goffice_api_ver >= %goffice_ver
Requires: libspreadsheet%{api_ver} = %EVR
Requires: %name-data = %EVR

BuildRequires(pre): rpm-build-gnome rpm-build-gir
BuildRequires: bison flex help2man gtk-doc
BuildRequires: libgnomeoffice%goffice_api_ver-devel >= %goffice_ver
BuildRequires: libgsf-devel >= %gsf_ver
BuildRequires: libgtk+3-devel
BuildRequires: intltool yelp-tools %_bindir/appstream-util desktop-file-utils
BuildRequires: zlib-devel
%{?_enable_introspection:BuildRequires: gobject-introspection-devel libgsf-gir-devel libgnomeoffice%goffice_api_ver-gir-devel}
%{?_with_perl:BuildRequires: perl-devel}
%{?_with_python:
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-pygobject3-devel}
%{?_with_gda:BuildRequires: libgda5-devel >= %gda_ver libgnomedb4-devel}
%{?_enable_check:BuildRequires: xvfb-run}

%description
Gnumeric is a modern full-featured spreadsheet program.  Gnumeric
contains built-in functions help system, analysis tools and plotting
interface.
There are nearly 95 percents of all Excel functions implemented in
Gnumeric besides a possibility to write your own functions in Python
and Perl.  There are Lotus 1-2-3, MS Excel 95/98/2000/XP, SYLK among
supported third party formats.

%description -l ru_RU.UTF8
Gnumeric - это современная полнофункциональная программа для работы с
электронными таблицами.  Gnumeric содержит встроенную систему подсказки
к функциям, средства анализа и умеет строить графики.  Программа
поддерживает приблизительно 95 процентов функций, имеющихся в MS Excel,
дополнить которые можно своими собственными функциями, написанными на
языке Python и Perl.  Среди поддерживаемых форматов - Lotus 1-2-3,
MS Excel 95/98/2000/XP, SYLK.

%package data
Summary: Arch independent files for Gnumeric
Group: Office
BuildArch: noarch

%description data
This package provides noarch data needed for Gnumeric to work.

%package -n libspreadsheet%{api_ver}
Summary: libspreadsheet library
Group: System/Libraries
Obsoletes: libspreadsheet1.10

%description -n libspreadsheet%{api_ver}
This package provide libspreadsheet library

%package -n libspreadsheet-devel
Summary: libspreadsheet library headers
Group: Development/C
Provides: libspreadsheet%{api_ver}-devel = %EVR
Requires: libspreadsheet%{api_ver} = %EVR

%description -n libspreadsheet-devel
This package provide libspreadsheet library headers

%package gir
Summary: GObject introspection data for the Gnumeric
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for the Gnumeric.

%package gir-devel
Summary: GObject introspection devel data for the Gnumeric
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %EVR

%description gir-devel
GObject introspection devel data for the Gnumeric.

%prep
%setup
%patch -p1
%patch10 -p1

# prevent linking against libpython3.x.a
sed -i s'@\-L\$PY_LIB_DIR@@' configure.ac

subst 's@zz-application\/zz-winassoc-xls;@@' %rdn_name.desktop.in

%build
%add_optflags %(getconf LFS_CFLAGS)
%if_enabled snapshot
NOCONFIGURE=1 ./autogen.sh
%else
%autoreconf
%endif
%configure \
    --disable-schemas-compile \
    %{subst_with gnome} \
    %{subst_with gda} \
    %{subst_with python} \
    %{subst_with perl} \
    %{?_enable_introspection:--enable-introspection=yes} \
    %{?_with_python:PYTHON=%__python3}
%nil
%make_build

%install
%makeinstall_std
%find_lang --with-gnome --output=%name.lang %name %name-%version %name-%version-functions

%check
%{?_enable_check:xvfb-run %make -k check VERBOSE=1}

%files
%_bindir/*
%_libdir/%name/
%_libdir/goffice/%goffice_api_ver/plugins/%name/%name.so
%_libdir/goffice/%goffice_api_ver/plugins/%name/plugin.xml
%{?_with_python:%python3_sitelibdir/gi/overrides/*}
%doc AUTHORS ChangeLog NEWS BUGS README COPYING HACKING

%exclude %_libdir/%name/%version/plugins/*/*.la
%exclude %_libdir/goffice/%goffice_api_ver/plugins/%name/%name.la
# requires no more existing python(gsf)
%{?_with_python:%exclude %_libdir/%name/%version/plugins/gnome-glossary}

%files data -f %name.lang
%dir %_datadir/%name
%_datadir/%name/%version/
%_desktopdir/%rdn_name.desktop
%_iconsdir/hicolor/*/apps/%rdn_name.*
%_man1dir/*
%config %_datadir/glib-2.0/schemas/org.gnome.gnumeric.dialogs.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gnumeric.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gnumeric.plugin.gschema.xml
%_datadir/metainfo/%rdn_name.appdata.xml

%if_enabled introspection
%files gir
%_typelibdir/Gnm-%api_ver.typelib

%files gir-devel
%_girdir/Gnm-%api_ver.gir
%endif

%files -n libspreadsheet%{api_ver}
%_libdir/libspreadsheet*

%files -n libspreadsheet-devel
%_includedir/libspreadsheet-%{api_ver}
%_pkgconfigdir/*

%changelog
