%def_disable snapshot

%define xdg_name org.gnome.Weather
%define ver_major 49
%define beta %nil
%define _libexecdir %_prefix/libexec

%def_enable check

Name: gnome-weather
Version: %ver_major.0
Release: alt1%beta

Summary: Access current weather conditions and forecasts
Group: Graphical desktop/GNOME
License: GPL-2.0-or-later
Url: https://apps.gnome.org/Weather

Vcs: https://gitlab.gnome.org/GNOME/gnome-weather.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version.tar
%endif

# node hangs on 32-bit
ExcludeArch: %ix86
BuildArch: noarch

Obsoletes: %name-data
Provides:  %name-data = %EVR

%define gtk4_ver 4.5
%define gi_ver 1.36.0
%define gjs_ver 1.71.0
%define gweather4_ver 3.90
%define adwaita_ver 1.4

Requires: libgjs >= %gjs_ver
Requires: libgweather4.0-gir >= %gweather4_ver
Requires: geoclue2

Requires: typelib(Geoclue)
Requires: typelib(Adw) = 1
Requires: typelib(GWeather) = 4.0
Requires: typelib(Soup) = 3.0
Requires: typelib(Json) = 1.0

BuildRequires(pre): rpm-macros-meson rpm-build-gnome rpm-build-gir
BuildRequires: meson /usr/bin/tsc yelp-tools
BuildRequires: libgtk4-devel >= %gtk4_ver libgjs-devel >= %gjs_ver
BuildRequires: libgweather4.0-devel >= %gweather4_ver pkgconfig(libgeoclue-2.0)
BuildRequires: pkgconfig(libadwaita-1) >= %adwaita_ver
BuildRequires: gobject-introspection-devel >= %gi_ver libgtk4-gir-devel libgweather4.0-gir-devel
%{?_enable_check:Buildrequires: /usr/bin/appstreamcli desktop-file-utils}

%description
%name is a small application that allows you to monitor the current
weather conditions for your city, or anywhere in the world, and to
access updated forecasts provided by various internet services.

%prep
%setup -n %name-%version%beta

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome --output=%name.lang %name %xdg_name

%check
%__meson_test

%files -f %name.lang
%_bindir/%name
%_desktopdir/%xdg_name.desktop
%_datadir/%xdg_name/
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/dbus-1/services/%xdg_name.BackgroundService.service
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_iconsdir/hicolor/scalable/apps/%xdg_name.svg
%_iconsdir/hicolor/symbolic/apps/%xdg_name-symbolic.svg
%_iconsdir/hicolor/scalable/status/*.svg
%_datadir/gnome-shell/search-providers/%xdg_name.search-provider.ini
%_datadir/metainfo/%xdg_name.metainfo.xml
%doc NEWS README*

%changelog
