# Defaults

# Avahi supersedes howl.
%def_enable avahi
%def_disable howl

# Choose one
%def_enable openssl
%def_disable gnutls

# Choose one
%def_disable fam
%def_enable gamin

# Optional components
%def_disable hal
%def_enable samba
%def_disable ipv6
%def_disable afs
# This one doesn't work (at all), as for 2.13.4
%def_disable cdda

# Enable gnome-vfs-daemon
%def_enable daemon

%def_disable static
%def_disable gtk_doc
%def_enable check


%define ver_major 2.24
%define oldname gnome-vfs2

Name: gnome-vfs
Version: %ver_major.4
Release: alt14
Epoch: 1

Summary: The GNOME virtual file-system libraries
Group: System/Libraries
License: GPL-2.0-or-later
Url: ftp://ftp.gnome.org

Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.bz2
Patch: gnome-vfs-2.24.4-enable-deprecated.patch
# https://bugzilla.suse.com/show_bug.cgi?id=1042650
Patch1: gnome-vfs-2.24-openssl11.patch

Patch2: gnome-vfs-2.24.1-gnutls.patch

Patch3: gnome-vfs-2.9.90-modules-conf.patch

# remove gnome-mime-data dependency
Patch4: gnome-vfs-2.24.1-disable-gnome-mime-data.patch

# CVE-2009-2473 neon, gnome-vfs2 embedded neon: billion laughs DoS attack
# https://bugzilla.redhat.com/show_bug.cgi?id=518215
Patch5: gnome-vfs-2.24.3-CVE-2009-2473.patch

# RH bug #197868
Patch6: gnome-vfs-2.15.91-mailto-command.patch

# (fc) 2.8.2-1mdk handle about: url (Fedora)
Patch8: gnome-vfs-2.8.2-schema_about_for_upstream.patch
# (fc) 2.8.3-5mdk support pamconsole mount option (Fedora)
Patch10: gnome-vfs-2.24.1-console-mount-opt.patch
# (fc) 2.17.91-2mdv replace references to gnomemeeting with ekiga
Patch11: gnome-vfs-2.17.91-fixh323.patch
# (fc) 2.17.91-3mdv allow OnlyShowIn=KDE .desktop to be used when running under KDE (Mdv bug #26999)
Patch12: gnome-vfs-2.17.91-onlyshow.patch
# (fc) 2.18.0.1-2mdv fix crash when fstab is being edited (Ubuntu) (GNOME bug #300547)
Patch13: gnome-vfs-2.20.0-fstab-edit-crash.patch
# (fc) 2.18.0.1-2mdv fix uuid and label mount point duplication (initial idea from Ubuntu bug #57701) (Mdv bug #32792)
Patch14: gnome-vfs-2.20.0-uuid-label-mount.patch
# (fc) 2.18.0.1-2mdv resolve mount point fstab symlinks (Ubuntu)
Patch15: gnome-vfs-2.20.0-resolve-fstab-symlinks.patch
Patch16: gnome-vfs-2.24.4-alt-link.patch

Patch17: 0002-dont-use-smbc_remove_unused_server.patch
Patch18: gnome-vfs-2.24.4-alt-gcc-14.patch

# https://bugzilla.redhat.com/show_bug.cgi?id=333041
# https://bugzilla.redhat.com/show_bug.cgi?id=33524
Patch300: gnome-vfs-2.20.0-ignore-certain-mountpoints.patch

# backported from upstream
# gnome-vfs-daemon exits on dbus, and constantly restarted causing dbus/hal to hog CPU
# https://bugzilla.redhat.com/show_bug.cgi?id=486286
Patch404: gnome-vfs-2.24.xx-utf8-mounts.patch
Patch500: gnome-vfs-2.24.4-alt-automake.patch

Obsoletes: %oldname-extras < 2.14.2
Provides: %oldname-extras = %version-%release
Obsoletes: %oldname < 2.14.2
Provides: %oldname = %version-%release
Conflicts: libgnome < 2.5.2

# From configure.in
%define dbus_glib_ver 0.60
%define GConf_ver 1.1.1
%define glib_ver 2.9.3
%define libxml2_ver 2.6.0
%define avahi_ver 0.6
%define howl_ver 0.9.6
%define hal_ver 0.5.7
%define gtk_doc_ver 1.0

%define shared_mime_info_ver 0.15

Requires(pre,post): GConf >= %GConf_ver
Requires: shared-mime-info >= %shared_mime_info_ver
%{?_enable_gamin:Requires: gamin libgamin-fam}

# From configure.in
BuildRequires(pre): gnome-common rpm-build-gnome
BuildRequires: intltool >= 0.35.0
BuildRequires: GConf >= %GConf_ver libGConf-devel >= %GConf_ver
BuildRequires: glib2-devel >= %glib_ver
BuildRequires: libxml2-devel >= %libxml2_ver
BuildRequires: bzlib-devel libkrb5-devel
BuildRequires: gtk-doc >= %gtk_doc_ver
%{?_enable_cdda:BuildRequires: libcdparanoia-devel}
%{?_enable_samba:BuildRequires: libsmbclient-devel}
%{?_enable_openssl:BuildRequires: libssl-devel}
%{?_enable_gnutls:BuildRequires: libgnutls-devel >= 1.0.0 libtasn1-devel libgcrypt-devel}
%{?_enable_howl:BuildRequires: libhowl-devel >= %howl_ver}
%if_enabled avahi
BuildRequires: libavahi-devel >= %avahi_ver
BuildRequires: libavahi-glib-devel >= %avahi_ver
%endif
%if_enabled hal
BuildRequires: libhal-devel >= %hal_ver
%endif
BuildRequires: libdbus-glib-devel
# For direct inotify support
BuildRequires: glibc-kernheaders
%{?_enable_fam:BuildRequires: libfam-devel}
%{?_enable_gamin:BuildRequires: gamin-devel}
BuildPreReq: openssh-clients gcc-c++  libattr-devel libacl-devel libcom_err-devel zlib-devel perl-XML-Parser

%description
GNOME VFS is the GNOME virtual file system. It is the foundation of the
Nautilus file manager. It provides a modular architecture and ships with
several modules that implement support for file systems, http, ftp and others.
It provides a URI-based API, a backend supporting asynchronous file operations,
a MIME type manipulation library and other features.

%package module-sftp
Summary: SSH/SFTP access module for GNOME VFS.
Group: System/Libraries
Requires: %name = %EVR
Requires: openssh-clients

%description module-sftp
GNOME VFS is the GNOME virtual file system. It is the foundation of the
Nautilus file manager. It provides a modular architecture and ships with
several modules that implement support for file systems, http, ftp and others.
It provides a URI-based API, a backend supporting asynchronous file operations,
a MIME type manipulation library and other features.

This package contains a GNOME VFS module for access to network resources
using SFTP (FTP over SSH) protocol. With this module, you can open URIs
that begin with ssh: and sftp: prefixes.

%package module-smb
Summary: Samba access module for GNOME VFS.
Group: System/Libraries
Requires: %name = %EVR

%description module-smb
GNOME VFS is the GNOME virtual file system. It is the foundation of the
Nautilus file manager. It provides a modular architecture and ships with
several modules that implement support for file systems, http, ftp and others.
It provides a URI-based API, a backend supporting asynchronous file operations,
a MIME type manipulation library and other features.

This package contains a GNOME VFS module for access to network resources
using SMB protocol (also known as "Windows shares"). With this module,
you can open URIs that begin with smb: prefix. Install it if you use
GNOME and there's a Windows machine with shared resources in your
network.

%package devel
Summary: Libraries and include files for developing GNOME VFS applications
Group: Development/GNOME and GTK+
Requires: %name = %EVR
Obsoletes: %oldname-devel < 2.14.2
Provides: %oldname-devel = %version-%release

%description devel
This package provides the necessary development libraries for writing
GNOME VFS modules and applications that use the GNOME VFS APIs.

%package devel-doc
Summary: Development documentation for GNOME VFS.
Group: Development/C
Conflicts: %name-devel < %EVR
Obsoletes: %oldname-devel-doc < 2.14.2
Provides: %oldname-devel-doc = %version-%release
Requires: gtk-doc
BuildArch: noarch

%description devel-doc
GNOME VFS is the GNOME virtual file system. It is the foundation of the
Nautilus file manager. It provides a modular architecture and ships with
several modules that implement support for file systems, http, ftp and others.
It provides a URI-based API, a backend supporting asynchronous file operations,
a MIME type manipulation library and other features.

This package contains development documentation for GNOME VFS.

%if_enabled static
%package devel-static
Summary: Static libraries for developing GNOME VFS applications
Group: Development/GNOME and GTK+
Requires: %name-devel = %EVR
Obsoletes: %oldname-devel-static < 2.14.2
Provides: %oldname-devel-static = %version-%release

%description devel-static
This package provides the necessary static development libraries
for writing GNOME VFS modules and applications that use the GNOME VFS APIs.
%endif

%package utils
Summary: Command line applications for GNOME VFS.
Group: Development/GNOME and GTK+
Requires: %name = %EVR
Obsoletes: %oldname-utils < 2.14.2
Provides: %oldname-utils = %version-%release

%description utils
This package contains command line tools for GNOME VFS.

%define _gtk_docdir %_datadir/gtk-doc/html
%define vfsmodulesdir %_libdir/%name-2.0/modules

%prep
%setup -q
%patch -p1
%patch1 -p1 -b .ssl11
%patch2 -p1 -b .gnutls

%patch3 -p1 -b .modules-conf
%patch4 -p1 -b .mime-data
%patch5 -p1 -b .CVE-2009-2473
%patch6 -p1 -b .mailto-command
%patch8 -p1 -b .about
%patch10 -p1 -b .pamconsole
%patch11 -p1 -b .fixh323
%patch12 -p1 -b .onlyshow
%patch13 -p1 -b .fstab-edit-crash
%patch14 -p1 -b .uuid-label-mount
%patch15 -p1 -b .resolve-fstab-symlinks
%patch16 -p1
%patch17 -p1
%patch18 -b .gcc-14

# send to upstream
%patch300 -p1 -b .ignore-certain-mount-points
%patch404 -p1 -b .utf8-mounts
%patch500 -p1 -b .automake

%build
mkdir -p %buildroot%_datadir/dbus-1/services/
gtkdocize --copy
%autoreconf
export LIBS="$LIBS `%_bindir/libgcrypt-config --libs`"
%configure \
    %{subst_enable static} \
    %{subst_enable howl} \
    %{subst_enable avahi} \
    %{subst_enable hal} \
    %{subst_enable cdda} \
    %{subst_enable samba} \
    --with-samba-includes=$(pkg-config --variable=includedir smbclient) \
    %{subst_enable openssl} \
    %{subst_enable gnutls} \
    %{subst_enable fam} \
    %{?_enable_gamin:--enable-fam} \
    %{subst_enable daemon} \
    --enable-ipv6 \
    --disable-selinux \
    --disable-schemas-install \
    %{?_enable_gtk_doc:--enable-gtk-doc}
%make_build

%install
%makeinstall_std
subst '/^\(ssh\|sftp\).*$/d' %buildroot%_sysconfdir/%name-2.0/modules/default-modules.conf
cat <<EOF >%buildroot%_sysconfdir/%name-2.0/modules/sftp-module.conf
ssh: sftp
sftp: sftp
EOF
chmod 644 %buildroot%_sysconfdir/%name-2.0/modules/sftp-module.conf

bzip2 -9fk ChangeLog

%find_lang --with-gnome %name-2.0
# system_smb.schemas is not included in this list, because SMB module is
# packaged separately.
%define schemas desktop_default_applications desktop_gnome_url_handlers system_http_proxy system_dns_sd

%check
%make -k check VERBOSE=1

%post
%gconf2_install %schemas

%preun
if [ $1 = 0 ]; then
%gconf2_uninstall %schemas
fi

%post module-smb
%gconf2_install system_smb

%preun module-smb
if [ $1 = 0 ]; then
%gconf2_uninstall system_smb
fi

%files -f %name-2.0.lang
%_libdir/*.so.*
%dir %_libdir/%name-2.0
%dir %vfsmodulesdir
%vfsmodulesdir/libvfs-test.so
%vfsmodulesdir/libcomputer.so
%vfsmodulesdir/libfile.so
%vfsmodulesdir/libtar.so
%vfsmodulesdir/libgzip.so
%vfsmodulesdir/libbzip2.so
%vfsmodulesdir/libnetwork.so
%vfsmodulesdir/libhttp.so
%vfsmodulesdir/libftp.so
%vfsmodulesdir/libdns-sd.so
%vfsmodulesdir/libnntp.so
%_libexecdir/gnome-vfs-daemon
%_datadir/dbus-1/services/gnome-vfs-daemon.service
%dir %_sysconfdir/gnome-vfs-2.0
%dir %_sysconfdir/gnome-vfs-2.0/modules
%config %_sysconfdir/gnome-vfs-2.0/modules/default-modules.conf
%config %_sysconfdir/gnome-vfs-2.0/modules/ssl-modules.conf
%config %gconf_schemasdir/*
%exclude %gconf_schemasdir/system_smb.schemas
%doc AUTHORS ChangeLog.* NEWS README

%files module-sftp
%vfsmodulesdir/libsftp.so
%config %_sysconfdir/gnome-vfs-2.0/modules/sftp-module.conf

%files module-smb
%vfsmodulesdir/libsmb.so
%config %_sysconfdir/gnome-vfs-2.0/modules/smb-module.conf
%config %gconf_schemasdir/system_smb.schemas

%files devel
%_includedir/*
%dir %_libdir/%name-2.0/include
%_libdir/%name-2.0/include/*
%_libdir/*.so
%_pkgconfigdir/*
%doc HACKING TODO

%files devel-doc
%_gtk_docdir/*

%if_enabled static
%files devel-static
%vfsmodulesdir/*.a
%_libdir/*.a
%endif

%files utils
%_bindir/*

%exclude %vfsmodulesdir/*.la

%changelog
