%def_disable snapshot
%define ver_major 49
%define beta %nil
%define xdg_name org.gnome.TextEditor

%def_enable check

Name: gnome-text-editor
Version: %ver_major.0
Release: alt1%beta

Summary: A simple Text Editor for GNOME
Group: Editors
License: GPL-3.0-or-later
Url: https://apps.gnome.org/TextEditor

Vcs: https://gitlab.gnome.org/GNOME/gnome-text-editor.git

%if_disabled snapshot
Source: https://download.gnome.org/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version.tar
%endif

%define glib_ver 2.80
%define gtk_ver 4.20
%define gtksource_ver 5.15
%define spelling_ver 0.3.1
%define adwaita_ver 1.8

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson yelp-tools
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libgtk4-devel >= %gtk_ver
BuildRequires: libgtksourceview5-devel >= %gtksource_ver
BuildRequires: pkgconfig(libspelling-1) >= %spelling_ver
BuildRequires: pkgconfig(libadwaita-1) >= %adwaita_ver
BuildRequires: libeditorconfig-devel
%{?_enable_check:BuildRequires: /usr/bin/appstreamcli desktop-file-utils}

%description
Text Editor is a simple editor for GNOME focused on being a good
general purpose default editor.

%prep
%setup -n %name-%version%beta

%build
%meson
%meson_build

%install
%meson_install
%find_lang %name --with-gnome

%check
%__meson_test

%files -f %name.lang
%_bindir/*
%_desktopdir/%xdg_name.desktop
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/dbus-1/services/%xdg_name.service
%_iconsdir/hicolor/*/apps/%{xdg_name}*.svg
%_datadir/metainfo/%xdg_name.metainfo.xml
%doc README* NEWS

%changelog
