%def_enable snapshot
%define _unpackaged_files_terminate_build 1
%define ver_major 43
%define beta .beta
%define binary_name vocalis
%define rdn_name app.drey.Vocalis
%define gst_api_ver 1.0

Name: gnome-sound-recorder
Version: %ver_major
Release: alt0.6%beta

Summary: Sound Recorder for GNOME
Group: Sound
License: LGPL-2.0-or-later
Url: https://wiki.gnome.org/Apps/SoundRecorder

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Vcs: https://gitlab.gnome.org/World/vocalis
Source: %name-%version%beta.tar
%endif

BuildArch: noarch

Obsoletes: gnome-media-common
Obsoletes: gnome-media-grecord
Provides:  gnome-media-grecord = %EVR
Provides:  %binary_name = %EVR

%define glib_ver 2.44
%define gtk_ver 4.4.0
%define gjs_ver 1.54
%define adwaita_ver 1.2.0

Requires: libgjs >= %gjs_ver
Requires: gst-plugins-base%gst_api_ver gst-plugins-good%gst_api_ver gst-plugins-bad%gst_api_ver
Requires: gstreamer%gst_api_ver-utils
# find ./ -name "*.js" |/usr/lib/rpm/gir-js.req |sort|uniq|sed -e 's/^/Requires: /'
Requires: typelib(Adw) = 1
Requires: typelib(Gio)
Requires: typelib(GLib)
Requires: typelib(GObject)
Requires: typelib(Gst)
Requires: typelib(GstPbutils)
Requires: typelib(GstPlayer)
Requires: typelib(Gtk) = 4.0
# explicitly required to avoid installation old version
Requires: libgst-plugins%gst_api_ver-gir

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson /usr/bin/tsc
BuildRequires: libgio-devel >= %glib_ver libgtk4-devel >= %gtk_ver
BuildRequires: libgjs-devel libgtk4-gir-devel yelp-tools
BuildRequires: pkgconfig(gstreamer-player-%gst_api_ver)
BuildRequires: gst-plugins%gst_api_ver-devel
BuildRequires: gstreamer%gst_api_ver-utils gst-plugins-base%gst_api_ver
BuildRequires: gst-plugins-good%gst_api_ver gst-plugins-bad%gst_api_ver
BuildRequires: gobject-introspection-devel pkgconfig(libadwaita-1) >= %adwaita_ver

%description
The GNOME application for record and play sound files.

%prep
%setup -n %name-%version%beta

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome --output=%name.lang %rdn_name

%files -f %name.lang
%_bindir/vocalis
%_datadir/%rdn_name
%_desktopdir/%rdn_name.desktop
%_datadir/glib-2.0/schemas/%rdn_name.gschema.xml
%_iconsdir/hicolor/*/apps/*
%_datadir/metainfo/%rdn_name.metainfo.xml
%doc NEWS README*


%changelog
