%def_disable snapshot

%define ver_major 49
%define beta %nil
%define domain gcampax.github.com
%define _libexecdir %_prefix/libexec

%def_enable classic_mode
%def_enable x11
%def_enable check

Name: gnome-shell-extensions
Version: %ver_major.0
Release: alt1%beta

Summary: GNOME Shell Extensions
Group: Graphical desktop/GNOME
License: GPL-2.0-or-later
Url: https://wiki.gnome.org/Projects/GnomeShell

Vcs: https://gitlab.gnome.org/GNOME/gnome-shell-extensions.git

BuildArch: noarch

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version%beta.tar
%endif

Requires: gnome-shell >= %version

# extensions/apps-menu/extension.js
# const {
#     Atk, Clutter, Gio, GLib, GMenu, GObject, Gtk, Meta, Shell, St
# } = imports.gi;
%{?_enable_classic_mode:Requires: typelib(GMenu) = 3.0}

BuildRequires(pre): rpm-macros-meson rpm-build-gir
BuildRequires: meson libgjs-devel sassc eslint

%description
GNOME Shell Extensions is a collection of extensions providing additional
and optional functionality to GNOME Shell.
See %_docdir/%name-%version/README for more information.

%package -n gnome-session-classic
Summary: GNOME Classic Wayland sessions
Group: Graphical desktop/GNOME
Requires: %name = %EVR

%description -n gnome-session-classic
This package provides files required for GNOME Classic mode on Wayland.

%package -n gnome-session-classic-xsession
Summary: GNOME Classic Xorg sessions
Group: Graphical desktop/GNOME
Requires: %name = %EVR

%description -n gnome-session-classic-xsession
This package provides files required for GNOME Classic mode on Xorg.

%package system-monitor
Summary: System Monitor GNOME Shell extension
Group: Graphical desktop/GNOME
Requires: %name = %EVR
Requires: typelib(GTop)
Requires: gnome-system-monitor >= %ver_major

%description system-monitor
This extension provides system monitor for GNOME Shell.

%prep
%setup -n %name-%version%beta

%build
%meson \
    %{subst_enable_meson_bool classic_mode classic_mode} \
    %{subst_enable_meson_bool x11 x11} \
    -Dextension_set=all
%nil
%meson_build

%install
%meson_install
%find_lang %name

%check
%__meson_test


# Classic mode
%if_enabled classic_mode
%files -n gnome-session-classic
%_datadir/wayland-sessions/gnome-classic-wayland.desktop
%_datadir/wayland-sessions/gnome-classic.desktop
%_datadir/gnome-shell/modes/classic.json
%_datadir/glib-2.0/schemas/00_org.gnome.shell.extensions.classic.gschema.override
%endif

%if_enabled x11
%files -n gnome-session-classic-xsession
%_datadir/xsessions/gnome-classic.desktop
%_datadir/xsessions/gnome-classic-xorg.desktop
%endif

%files system-monitor
%dir %_datadir/gnome-shell/extensions/system-monitor@gnome-shell-extensions.%domain
%_datadir/glib-2.0/schemas/org.gnome.shell.extensions.system-monitor.gschema.xml
%_datadir/gnome-shell/extensions/system-monitor@gnome-shell-extensions.%domain/extension.js
%_datadir/gnome-shell/extensions/system-monitor@gnome-shell-extensions.%domain/metadata.json
%_datadir/gnome-shell/extensions/system-monitor@gnome-shell-extensions.%domain/stylesheet.css
%_datadir/gnome-shell/extensions/system-monitor@gnome-shell-extensions.%domain/icons/

%files -f %name.lang
## Extensions
%dir %_datadir/gnome-shell/extensions
# light-style
%dir %_datadir/gnome-shell/extensions/light-style@gnome-shell-extensions.gcampax.github.com
%_datadir/gnome-shell/extensions/light-style@gnome-shell-extensions.gcampax.github.com/extension.js
%_datadir/gnome-shell/extensions/light-style@gnome-shell-extensions.gcampax.github.com/metadata.json

# windowsNavigator
%dir %_datadir/gnome-shell/extensions/windowsNavigator@gnome-shell-extensions.%domain
%_datadir/gnome-shell/extensions/windowsNavigator@gnome-shell-extensions.%domain/extension.js
%_datadir/gnome-shell/extensions/windowsNavigator@gnome-shell-extensions.%domain/metadata.json
%_datadir/gnome-shell/extensions/windowsNavigator@gnome-shell-extensions.%domain/stylesheet.css

# auto-move-windows
%dir %_datadir/gnome-shell/extensions/auto-move-windows@gnome-shell-extensions.%domain
%_datadir/gnome-shell/extensions/auto-move-windows@gnome-shell-extensions.%domain/extension.js
%_datadir/gnome-shell/extensions/auto-move-windows@gnome-shell-extensions.%domain/metadata.json
%_datadir/gnome-shell/extensions/auto-move-windows@gnome-shell-extensions.%domain/prefs.js
%_datadir/glib-2.0/schemas/org.gnome.shell.extensions.auto-move-windows.gschema.xml

# user theme loading
%dir %_datadir/gnome-shell/extensions/user-theme@gnome-shell-extensions.%domain
%_datadir/gnome-shell/extensions/user-theme@gnome-shell-extensions.%domain/extension.js
%_datadir/gnome-shell/extensions/user-theme@gnome-shell-extensions.%domain/prefs.js
%_datadir/gnome-shell/extensions/user-theme@gnome-shell-extensions.%domain/util.js
%_datadir/gnome-shell/extensions/user-theme@gnome-shell-extensions.%domain/metadata.json
%_datadir/glib-2.0/schemas/org.gnome.shell.extensions.user-theme.gschema.xml

# removable drives menu
%dir %_datadir/gnome-shell/extensions/drive-menu@gnome-shell-extensions.%domain
%_datadir/gnome-shell/extensions/drive-menu@gnome-shell-extensions.%domain/extension.js
%_datadir/gnome-shell/extensions/drive-menu@gnome-shell-extensions.%domain/metadata.json
%_datadir/gnome-shell/extensions/drive-menu@gnome-shell-extensions.%domain/stylesheet.css

# apps-menu
%dir %_datadir/gnome-shell/extensions/apps-menu@gnome-shell-extensions.%domain
%_datadir/gnome-shell/extensions/apps-menu@gnome-shell-extensions.%domain/extension.js
%_datadir/gnome-shell/extensions/apps-menu@gnome-shell-extensions.%domain/metadata.json
%_datadir/gnome-shell/extensions/apps-menu@gnome-shell-extensions.%domain/stylesheet.css
%_datadir/glib-2.0/schemas/org.gnome.shell.extensions.apps-menu.gschema.xml

# native-window-placement
%dir %_datadir/gnome-shell/extensions/native-window-placement@gnome-shell-extensions.%domain
%_datadir/gnome-shell/extensions/native-window-placement@gnome-shell-extensions.%domain/extension.js
%_datadir/gnome-shell/extensions/native-window-placement@gnome-shell-extensions.%domain/metadata.json
%_datadir/glib-2.0/schemas/org.gnome.shell.extensions.native-window-placement.gschema.xml

# places-menu
%dir %_datadir/gnome-shell/extensions/places-menu@gnome-shell-extensions.%domain
%_datadir/gnome-shell/extensions/places-menu@gnome-shell-extensions.%domain/extension.js
%_datadir/gnome-shell/extensions/places-menu@gnome-shell-extensions.%domain/metadata.json
%_datadir/gnome-shell/extensions/places-menu@gnome-shell-extensions.%domain/stylesheet.css
%_datadir/gnome-shell/extensions/places-menu@gnome-shell-extensions.%domain/placeDisplay.js

# workspace indicator
%dir %_datadir/gnome-shell/extensions/workspace-indicator@gnome-shell-extensions.%domain
%_datadir/gnome-shell/extensions/workspace-indicator@gnome-shell-extensions.%domain/extension.js
%_datadir/gnome-shell/extensions/workspace-indicator@gnome-shell-extensions.%domain/metadata.json
%_datadir/gnome-shell/extensions/workspace-indicator@gnome-shell-extensions.%domain/prefs.js
%_datadir/gnome-shell/extensions/workspace-indicator@gnome-shell-extensions.%domain/stylesheet-dark.css
%_datadir/gnome-shell/extensions/workspace-indicator@gnome-shell-extensions.%domain/stylesheet-light.css
%_datadir/gnome-shell/extensions/workspace-indicator@gnome-shell-extensions.%domain/workspaceIndicator.js
%_datadir/gnome-shell/extensions/workspace-indicator@gnome-shell-extensions.gcampax.github.com/workspacePrefs.js
%_datadir/glib-2.0/schemas/org.gnome.shell.extensions.workspace-indicator.gschema.xml

# launch-new-instance
%dir %_datadir/gnome-shell/extensions/launch-new-instance@gnome-shell-extensions.%domain
%_datadir/gnome-shell/extensions/launch-new-instance@gnome-shell-extensions.%domain/extension.js
%_datadir/gnome-shell/extensions/launch-new-instance@gnome-shell-extensions.%domain/metadata.json

# window-list
%dir %_datadir/gnome-shell/extensions/window-list@gnome-shell-extensions.%domain
%_datadir/gnome-shell/extensions/window-list@gnome-shell-extensions.%domain/extension.js
%_datadir/gnome-shell/extensions/window-list@gnome-shell-extensions.%domain/metadata.json
%_datadir/gnome-shell/extensions/window-list@gnome-shell-extensions.%domain/prefs.js
%_datadir/gnome-shell/extensions/window-list@gnome-shell-extensions.gcampax.github.com/workspacePrefs.js
%_datadir/gnome-shell/extensions/window-list@gnome-shell-extensions.%domain/stylesheet-dark.css
%_datadir/gnome-shell/extensions/window-list@gnome-shell-extensions.%domain/stylesheet-light.css
%_datadir/gnome-shell/extensions/window-list@gnome-shell-extensions.%domain/stylesheet-workspace-switcher-dark.css
%_datadir/gnome-shell/extensions/window-list@gnome-shell-extensions.%domain/stylesheet-workspace-switcher-light.css
%_datadir/gnome-shell/extensions/window-list@gnome-shell-extensions.%domain/workspaceIndicator.js
%_datadir/glib-2.0/schemas/org.gnome.shell.extensions.window-list.gschema.xml

# screenshot-window-sizer
%dir %_datadir/gnome-shell/extensions/screenshot-window-sizer@gnome-shell-extensions.%domain
%_datadir/glib-2.0/schemas/org.gnome.shell.extensions.screenshot-window-sizer.gschema.xml
%_datadir/gnome-shell/extensions/screenshot-window-sizer@gnome-shell-extensions.%domain/extension.js
%_datadir/gnome-shell/extensions/screenshot-window-sizer@gnome-shell-extensions.%domain/metadata.json
%_datadir/gnome-shell/extensions/screenshot-window-sizer@gnome-shell-extensions.%domain/stylesheet.css

# status-icons
%dir %_datadir/gnome-shell/extensions/status-icons@gnome-shell-extensions.gcampax.github.com
%_datadir/gnome-shell/extensions/status-icons@gnome-shell-extensions.%domain/extension.js
%_datadir/gnome-shell/extensions/status-icons@gnome-shell-extensions.%domain/metadata.json

%doc NEWS README.md

%changelog
