%def_disable snapshot
%define _userunitdir %(pkg-config systemd --variable systemduserunitdir)

%define ver_major 49
%define beta %nil
%define _libexecdir %_prefix/libexec
%def_enable docs
%def_enable man
%def_enable x11

Name: gnome-session
Version: %ver_major.1
Release: alt1%beta

Summary: The gnome session programs for the GNOME GUI desktop environment
Group: Graphical desktop/GNOME
License: GPL-2.0-or-later
Url: https://wiki.gnome.org/Projects/SessionManagement

Vcs: https://gitlab.gnome.org/GNOME/gnome-session.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version%beta.tar
%endif

%define glib_ver 2.82.0
%define polkit_ver 0.91
%define upower_ver 0.9
%define systemd_ver 242

Requires(pre): libcanberra-gnome libcanberra-gtk3
Requires: altlinux-freedesktop-menu-gnome3
Requires: dbus-tools-gui
Requires: gnome-filesystem
Requires: upower gcr gcr4
Requires: xdg-user-dirs

Requires: icon-theme-hicolor gnome-icon-theme-symbolic gnome-themes-standard

BuildRequires(pre): rpm-macros-meson rpm-build-gnome rpm-build-systemd
BuildRequires: meson
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libgtk4-devel
BuildRequires: pkgconfig(gnome-desktop-4) libjson-glib-devel
BuildRequires: perl-XML-Parser xmlto docbook-utils
BuildRequires: pkgconfig(systemd) >= %systemd_ver
%{?_enable_x11:BuildRequires: pkgconfig(x11) pkgconfig(sm) pkgconfig(ice)
BuildRequires: pkgconfig(xtrans) pkgconfig(xcomposite)}
%{?_enable_docs:BuildRequires: docbook-utils xmlto}
%{?_enable_man:BuildRequires: docbook-utils docbook-style-xsl xsltproc}
# since 3.22.2
BuildRequires: libepoxy-devel

%description
GNOME (GNU Network Object Model Environment) is a user-friendly set of
applications and desktop tools to be used in conjunction with a window
manager for the X Window System.

This package provides the GNOME session manager, as well as a
configuration program to choose applications starting on login.

%package wayland
Summary: A Wayland session for the GNOME
Group: Graphical desktop/GNOME
BuildArch: noarch
Requires: %name = %EVR
Requires: xorg-xwayland

%description wayland
This package permits to log into GNOME using Wayland.

%package xsession
Summary: A Xorg session for the GNOME
Group: Graphical desktop/GNOME
BuildArch: noarch
Requires: %name = %EVR
Requires(pre): xinitrc

%description xsession
This package permits to log into GNOME using Xorg.

%prep
%setup -n %name-%version%beta

%build
export PATH=$PATH:/sbin
%meson \
    %{subst_enable_meson_bool x11 x11} \
    %{subst_enable_meson_bool docs docbook} \
    %{subst_enable_meson_bool man man}
%nil
%meson_build

%install
%meson_install

%find_lang --with-gnome --output=%name.lang %name-%ver_major

%check
%meson_test

%files -f %name.lang
%_bindir/%name
%{?_enable_x11:
%_bindir/%name-inhibit
%_bindir/%name-quit}
%_libexecdir/%name-init-worker
%_libexecdir/%name-service
%_libexecdir/%name-ctl
%_desktopdir/gnome-mimeapps.list
%dir %_datadir/%name
%_datadir/xdg-desktop-portal/gnome-portals.conf
%dir %_datadir/%name/sessions
%_datadir/%name/sessions/gnome.session
%config %_datadir/glib-2.0/schemas/org.gnome.SessionManager.gschema.xml
%dir %_userunitdir/app-flatpak-.scope.d
%_userunitdir/app-flatpak-.scope.d/override.conf
%dir %_userunitdir/app-gnome-.scope.d
%_userunitdir/app-gnome-.scope.d/override.conf
%dir %_userunitdir/gnome-session@gnome.target.d
%_userunitdir/gnome-session@gnome.target.d/gnome.session.conf
%_userunitdir/%name-basic-services.target
%_userunitdir/%name-initialized.target
%_userunitdir/%name-manager.target
%_userunitdir/%name-manager@.service
%_userunitdir/%name-monitor.service
%_userunitdir/%name-pre.target
%_userunitdir/%name-restart-dbus.service
%_userunitdir/%name-shutdown.target
%_userunitdir/%name-signal-init.service
%_userunitdir/%name-wayland.target
%_userunitdir/%name-wayland@.target
%_userunitdir/%name.target
%_userunitdir/%name@.target
%{?_enable_x11:
%_userunitdir/gnome-session-x11-services-ready.target
%_userunitdir/%name-x11-services.target
%_userunitdir/%name-x11.target
%_userunitdir/%name-x11@.target
}
%{?_enable_man:
%_man1dir/%name-inhibit.*
%_man1dir/%name-quit.*
%_man1dir/%name.*}

%doc NEWS README*
%doc %_datadir/doc/%name/

%if_enabled x11
%files xsession
%_datadir/xsessions/gnome.desktop
%_datadir/xsessions/gnome-xorg.desktop
%endif

%files wayland
%_datadir/wayland-sessions/gnome.desktop
%_datadir/wayland-sessions/gnome-wayland.desktop


%changelog
