%def_disable snapshot
%define _libexecdir %_prefix/libexec
%define ver_major 49
%define beta %nil
%define xdg_name org.gnome.RemoteDesktop

%def_enable vnc
%def_enable rdp
%def_enable man

Name: gnome-remote-desktop
Version: %ver_major.1
Release: alt1%beta

Summary: GNOME Remote Desktop
License: GPL-2.0-or-later
Group: Networking/Remote access
Url: https://gitlab.gnome.org/GNOME/gnome-remote-desktop

Vcs: https://gitlab.gnome.org/GNOME/gnome-remote-desktop.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version.tar
%endif

%define glib_ver 2.76
%define pw_api_ver 0.3
%define pw_ver 0.3.49
%define vnc_ver 0.9.11
%define freerdp_ver 3.15
%define fuse_ver 3.9.1
%define xkbc_ver 1.0.0
%define nvenc_ver 11.1.5.0
%define ei_ver 1.4.0
%define polkit_ver 122

Requires: pipewire >= %pw_ver
Requires: fuse3 >= %fuse_ver
Requires: polkit >= %polkit_ver
%{?_enable_rdp:Requires: freerdp3 >= %freerdp_ver}

BuildRequires(pre): rpm-macros-meson rpm-build-systemd
BuildRequires: meson libgio-devel >= %glib_ver libgudev-devel
BuildRequires: pkgconfig(libpipewire-%pw_api_ver) >= %pw_ver
BuildRequires: pkgconfig(opus)
BuildRequires: libtpm2-tss-devel libfdk-aac-devel
BuildRequires: libfuse3-devel >= %fuse_ver
BuildRequires: libxkbcommon-devel >= %xkbc_ver
BuildRequires: libsecret-devel libnotify-devel libcairo-devel
BuildRequires: libepoxy-devel libdrm-devel libgbm-devel
BuildRequires: pkgconfig(ffnvcodec) >= %nvenc_ver
BuildRequires: pkgconfig(libva-drm)
BuildRequires: pkgconfig(vulkan) /usr/bin/glslc /usr/bin/spirv-opt
BuildRequires: libei-devel >= %ei_ver
BuildRequires: libdbus-devel libpolkit-devel >= %polkit_ver
BuildRequires: /bin/dbus-run-session /usr/bin/openssl
BuildRequires: pipewire wireplumber mutter-gnome
%{?_enable_vnc:BuildRequires: libvncserver-devel >= %vnc_ver}
%{?_enable_rdp:BuildRequires: pkgconfig(freerdp3) >= %freerdp_ver}
%{?_enable_man:BuildRequires: /usr/bin/a2x xmllint}

%description
Remote desktop daemon for GNOME using pipewire.

%prep
%setup -n %name-%version%beta

%build
%meson \
    %{subst_enable_meson_bool rdp rdp} \
    %{subst_enable_meson_bool vnc vnc} \
    %{subst_enable_meson_bool man man} \
    -Dsystemd_user_unit_dir=%_userunitdir
%nil
%meson_build

%install
%meson_install
%find_lang %name

%files -f %name.lang
%_bindir/grdctl
%_libexecdir/%name-daemon
%_libexecdir/%name-enable-service
%_libexecdir/%name-configuration-daemon
%_unitdir/%name.service
%_unitdir/%name-configuration.service
%_sysusersdir/%name-sysusers.conf
%_tmpfilesdir/%name-tmpfiles.conf
%_userunitdir/%name.service
%_userunitdir/%name-handover.service
%_userunitdir/%name-headless.service
%_desktopdir/%xdg_name.Handover.desktop
%_datadir/glib-2.0/schemas/org.gnome.desktop.remote-desktop.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.desktop.remote-desktop.enums.xml
%{?_enable_man:%_man1dir/grdctl.1*}
%dir %_datadir/%name
%_datadir/%name/grd-cuda-damage-utils_30.ptx
%_datadir/%name/grd-cuda-avc-utils_30.ptx
%_datadir/%name/grd.conf
%dir %_datadir/%name/shaders
%_datadir/%name/shaders/grd-avc-dual-view_opt.spv
%_datadir/dbus-1/system-services/%xdg_name.Configuration.service
%_datadir/dbus-1/system.d/%xdg_name.conf
%_datadir/polkit-1/actions/org.gnome.remotedesktop.configure-system-daemon.policy
%_datadir/polkit-1/actions/org.gnome.remotedesktop.enable-system-daemon.policy
%_datadir/polkit-1/rules.d/20-%name.rules
%doc README*

%changelog
