%def_disable snapshot

%define ver_major 3.56
%define _libexecdir %_prefix/libexec
%define xdg_name org.gnome.OnlineAccounts
%define namespace Goa
%define api_ver 1.0

%def_enable backend
%def_enable kerberos
%def_enable owncloud
%def_enable webdav
%def_enable exchange
%def_enable google
%def_enable imap_smtp
%def_enable doc
%def_enable man

Name: gnome-online-accounts
Version: %ver_major.1
Release: alt1

Summary: Provide online accounts information
Group: Graphical desktop/GNOME
License: LGPL-2.1-or-later
Url: https://wiki.gnome.org/Projects/GnomeOnlineAccounts

Vcs: https://gitlab.gnome.org/GNOME/gnome-online-accounts.git

%if_enabled snapshot
Source: %name-%version.tar
%else
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%endif

Requires: lib%name = %EVR
# realmd requires /sbin/telinit provided by sysvinit or systemd-sysvinit packages
%{?_enable_kerberos:Requires: realmd systemd-sysvinit}
Requires: dconf gnome-keyring

%define glib_ver 2.68
%define gtk4_ver 4.15.2
%define adw_ver 1.4
%define gcr_ver 4.1.0
%define rest_ver 0.9.1
%define soup3_ver 3.0.7

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson vala-tools
BuildRequires: glib2-devel >= %glib_ver
BuildRequires: pkgconfig(rest-1.0) >= %rest_ver
BuildRequires: pkgconfig(gcr-4) >= %gcr_ver
BuildRequires: pkgconfig(libsoup-3.0) >= %soup3_ver
BuildRequires: libgtk4-devel >= %gtk4_ver
BuildRequires: pkgconfig(libadwaita-1) >= %adw_ver
BuildRequires: libjson-glib-devel
BuildRequires: libsecret-devel libdbus-devel
BuildRequires: pkgconfig(libkeyutils)
BuildRequires: gobject-introspection-devel
%{?_enable_kerberos:BuildRequires: pkgconfig(krb5)}
%{?_enable_doc:BuildRequires: gi-docgen}
%{?_enable_man:BuildRequires: xsltproc docbook-dtds docbook-style-xsl}

%description
gnome-online-accounts provides interfaces so applications and
libraries in GNOME can access the user's online accounts.

%package -n lib%name
Summary: %name shared libraries
Group: System/Libraries

%description -n lib%name
This package contains shared %name libraries.

%package -n lib%name-devel
Summary: Development files for %name libraries
Group: Development/C
Requires: lib%name = %EVR

%description -n lib%name-devel
This package contains libraries and header files for developing
applications that use %name libraries.

%package -n lib%name-gir
Summary: GObject introspection data for the %name libraries
Group: System/Libraries
Requires: lib%name = %EVR

%description -n lib%name-gir
GObject introspection data for the %name libraries

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the %name libraries
Group: Development/Other
BuildArch: noarch
Requires: lib%name-gir = %EVR
Requires: lib%name-devel = %EVR

%description -n lib%name-gir-devel
GObject introspection devel data for the %name libraries

%package -n lib%name-devel-doc
Summary: Development documentation for %name
Group: Development/C
Conflicts: lib%name < %version
BuildArch: noarch

%description -n lib%name-devel-doc
This package contains development documentation for the %name libraries.

%prep
%setup
# fix pkgconfig after gtk4 port
sed -i s'|gtk+-3.0|libadwaita-1|' src/goabackend/meson.build

%build
%meson \
    %{subst_enable_meson_bool man man} \
    %{subst_enable_meson_bool doc documentation} \
    %{subst_enable_meson_bool backend goabackend} \
    %{subst_enable_meson_bool exchange exchange} \
    %{subst_enable_meson_bool google google} \
    %{subst_enable_meson_bool imap_smtp imap_smtp} \
    %{subst_enable_meson_bool kerberos kerberos} \
    %{subst_enable_meson_bool owncloud owncloud} \
    %{subst_enable_meson_bool webdav webdav}
%nil
%meson_build

%install
%meson_install
%find_lang --output=%name.lang %name %{?_enable_telepathy:%name-tpaw}

%files -f %name.lang
%if_enabled backend
%_libexecdir/goa-daemon
%_libexecdir/goa-identity-service
%_libexecdir/goa-oauth2-handler
%_desktopdir/%xdg_name.OAuth2.desktop
%_datadir/dbus-1/services/org.gnome.Identity.service
%_datadir/dbus-1/services/%xdg_name.service
%{?_enable_man:%_man8dir/goa-daemon.*}
%endif
%_iconsdir/hicolor/*/*/*.svg
%{?_enable_telepathy:%_iconsdir/hicolor/scalable/apps/im-*.svg}
%doc README* NEWS

%files -n lib%name
%_libdir/libgoa-%api_ver.so.*
%dir %_libdir/goa-%api_ver

%if_enabled backend
%_libdir/libgoa-backend-%api_ver.so.*
%endif

%files -n lib%name-devel
%_includedir/goa-%api_ver/
%dir %_libdir/goa-%api_ver/include
%_libdir/goa-%api_ver/include/goaconfig.h
%_libdir/libgoa-%api_ver.so

%if_enabled backend
%_libdir/libgoa-backend-%api_ver.so
%_pkgconfigdir/goa-backend-%api_ver.pc
%endif

%_pkgconfigdir/goa-%api_ver.pc
%_vapidir/goa-%api_ver.deps
%_vapidir/goa-%api_ver.vapi

%files -n lib%name-gir
%_typelibdir/%namespace-%api_ver.typelib

%files -n lib%name-gir-devel
%_girdir/%namespace-%api_ver.gir

%if_enabled doc
%files -n lib%name-devel-doc
%_datadir/doc/%name
%endif

%changelog
