%def_enable snapshot
%define ver_major 42

Name: gnome-nettool
Version: %ver_major.0
Release: alt2

Summary: GNOME interface for various networking tools
License: GPL-2.0-or-later
Group: Graphical desktop/GNOME
Url: https://www.gnome.org

Vcs: https://gitlab.gnome.org/GNOME/gnome-nettool.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

Obsoletes: gnome-netinfo
Provides: gnome-netinfo = %version-%release

Requires: net-tools
Requires: iputils
Requires: traceroute
Requires: bind-utils
Requires: nmap
Requires: whois

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson yelp-tools desktop-file-utils %_bindir/appstream-util
BuildRequires: libgtk+3-devel >= 2.99.2
BuildRequires: libgio-devel libgtop-devel

%description
GNOME Nettool is a set of front-ends to various networking command-line
tools, like ping, netstat, ifconfig, whois, traceroute, finger.

%prep
%setup
sed -E -i "s/\('(desktop|appdata)'\,/(/" data/meson.build

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/%name
%_desktopdir/%name.desktop
%_datadir/%name/
%_datadir/glib-2.0/schemas/*.xml
%_iconsdir/hicolor/*/apps/%{name}*
%_datadir/metainfo/%name.appdata.xml
%doc README NEWS TODO ChangeLog

%changelog
