%define ver_major 49
%define beta %nil
%define api_ver 1.0
%define _libexecdir %_prefix/libexec
%define xdg_name org.gnome.Maps

Name: gnome-maps
Version: %ver_major.2
Release: alt1%beta

Summary: Maps is a map application for GNOME
License: GPL-2.0-or-later and LGPL-2.1-or-later
Group: Graphical desktop/GNOME
Url: https://apps.gnome.org/Maps/

Vcs: https://gitlab.gnome.org/GNOME/gnome-maps.git

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz

%set_typelibdir %_libdir/%name/girepository-1.0

%define meson_ver 0.61
%define glib_ver 2.66
%define gjs_ver 1.69.2
%define gtk_api_ver 4.0
%define adwaita_ver 1.8
%define geocode_api_ver 2.0
%define geocode_ver 3.26.0
%define geoclue_ver 2.4.0
%define shumate_ver 1.5
%define gweather_api_ver 4.0
%define soup_api_ver 3.0
%define rest_api_ver 1.0

Requires: geoclue2 >= %geoclue_ver
Requires: libgeocode-glib%geocode_api_ver-gir >= %geocode_ver
Requires: libshumate-gir >= %shumate_ver

# find ./ -name "*.js" |/usr/lib/rpm/gir-js.req |sort|uniq|sed -e 's/^/Requires: /'
Requires: typelib(Gdk)
Requires: typelib(GdkPixbuf)
Requires: typelib(Geoclue)
Requires: typelib(GeocodeGlib) = %geocode_api_ver
Requires: typelib(Graphene)
Requires: typelib(Gio)
Requires: typelib(GLib)
Requires: typelib(GnomeMaps)
Requires: typelib(GObject)
Requires: typelib(Gtk) = %gtk_api_ver
Requires: typelib(GWeather) = %gweather_api_ver
Requires: typelib(Adw) = 1
Requires: typelib(Pango)
Requires: typelib(PangoCairo)
Requires: typelib(Rest) = %rest_api_ver
Requires: typelib(Secret)
Requires: typelib(Shumate)
Requires: typelib(Soup) = %soup_api_ver
Requires: typelib(Xdp) = 1.0

BuildRequires(pre): rpm-macros-meson rpm-build-gir
BuildRequires: meson >= %meson_ver yelp-tools %_bindir/appstreamcli desktop-file-utils
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: pkgconfig(libadwaita-1) >= %adwaita_ver
BuildRequires: libgjs-devel >= %gjs_ver gobject-introspection-devel
BuildRequires: pkgconfig(libgeoclue-2.0) >= %geoclue_ver
BuildRequires: pkgconfig(geocode-glib-%geocode_api_ver)
BuildRequires: pkgconfig(shumate-1.0) >= %shumate_ver pkgconfig(libxml-2.0)
BuildRequires: pkgconfig(librsvg-2.0) pkgconfig(libportal)
BuildRequires: gir(GeocodeGlib) = %geocode_api_ver gir(GWeather) = %gweather_api_ver
BuildRequires: gir(Shumate) gir(Rest) = %rest_api_ver

%description
Maps is a map application for GNOME.

%prep
%setup -n %name-%version%beta

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/*
%_libdir/%name/
%_desktopdir/%xdg_name.desktop
%_datadir/%name/
%_iconsdir/hicolor/scalable/apps/*.svg
%_iconsdir/hicolor/symbolic/apps/%{xdg_name}*.svg
%_datadir/dbus-1/services/%xdg_name.service
%config %_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/metainfo/%xdg_name.metainfo.xml
%doc README NEWS

%exclude %_libdir/%name/*.so
%exclude %_datadir/%name/gir-1.0/GnomeMaps-%api_ver.gir

%changelog
