%def_disable snapshot

%define ver_major 49
%define beta %nil
%define _libexecdir %_prefix/libexec
%define _localstatedir %_var

%def_enable malcontent

Name: gnome-initial-setup
Version: %ver_major.0
Release: alt1%beta

Summary: GNOME Initial Setup
Group: Graphical desktop/GNOME
License: GPL-2.0-or-later
Url: https://gitlab.gnome.org/GNOME/gnome-initial-setup

Vcs: https://gitlab.gnome.org/GNOME/gnome-initial-setup.git

%if_disabled snapshot
Source: https://download.gnome.org/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version%beta.tar
%endif

%define systemd_ver 242
%define session_ver %ver_major
%define nm_ver 1.2
%define nma_ver 1.0
%define glib_ver 2.64.0
%define gtk4_ver 4.17
%define adwaita_ver 1.4
%define secret_ver 0.18.8
%define geoclue_ver 2.4.3
%define packagekit_ver 1.1.4
%define gsds_ver 3.37.1
%define ibus_ver 1.4.99
%define malcontent_ui_api_ver 1
%define malcontent_ver 0.11
%define webkit_api_ver 6.0
%define webkit_ver 2.39.1
%define goa_ver 3.45.2

#Requires: gnome-shell >= 3.37.92 gdm
#Requires: gnome-online-accounts >= %goa_ver

Requires: gnome-session >= %session_ver
Requires: gdm dconf geoclue2 >= %geoclue_ver
Requires: gsettings-desktop-schemas >= %gsds_ver
Requires: ibus tecla
Requires: gnome-tour
Requires: shadow-utils
%{?_enable malcontent:Requires: malcontent >= %malcontent_ver}

BuildRequires(pre): rpm-macros-meson rpm-build-systemd
BuildRequires: meson libgio-devel >= %glib_ver
BuildRequires: libgtk4-devel >= %gtk4_ver
BuildRequires: pkgconfig(libadwaita-1) >= %adwaita_ver
BuildRequires: gsettings-desktop-schemas-devel >= %gsds_ver
BuildRequires: libnm-devel >= %nm_ver pkgconfig(libnma-gtk4) >= %nma_ver
BuildRequires: libkrb5-devel libpwquality-devel
BuildRequires: libxkbfile-devel libibus-devel >= %ibus_ver librest-devel
BuildRequires: libaccountsservice-devel pkgconfig(rest-1.0) pkgconfig(gnome-desktop-4)
BuildRequires: pkgconfig(gweather4) libgnome-online-accounts-devel
BuildRequires: gdm-libs-devel iso-codes-devel libpolkit-devel
BuildRequires: gobject-introspection-devel libgtk4-gir-devel
BuildRequires: libsecret-devel >= %secret_ver
BuildRequires: libgeoclue2-devel >= %geoclue_ver pkgconfig(geocode-glib-2.0)
BuildRequires: pkgconfig(webkitgtk-%webkit_api_ver) >= %webkit_ver
BuildRequires: pkgconfig(systemd) >= %systemd_ver
%{?_enable_malcontent:BuildRequires: pkgconfig(malcontent-ui-%malcontent_ui_api_ver) >= %malcontent_ver}

%description
GNOME Initial Setup is an alternative to firstboot, providing
a good setup experience to welcome you to your system, and walks
you through configuring it. It is integrated with gdm.

%prep
%setup -n %name-%version%beta

%build
%meson \
    %{subst_enable_meson_feature malcontent parental_controls}
%nil
%meson_build

%install
%meson_install

mkdir -p %buildroot%_localstatedir/lib/%name
mkdir -p %buildroot%_localstatedir/run/%name

%find_lang %name

%pre
useradd -rM -d %_localstatedir/lib/%name -s /sbin/nologin %name &>/dev/null || :

%files -f %name.lang
%_libexecdir/%name
%_libexecdir/%name-copy-worker
%_desktopdir/%name.desktop
%_datadir/dconf/profile/%name
%dir %_datadir/%name
%_datadir/%name/initial-setup-dconf-defaults
%_datadir/gnome-session/sessions/%name.session
%_datadir/gnome-shell/modes/initial-setup.json
%_datadir/polkit-1/rules.d/20-gnome-initial-setup.rules
%_userunitdir/*
%_sysusersdir/%name.conf

%attr(1770, %name, %name) %dir %_localstatedir/lib/%name
%attr(1777, root, %name) %dir %_localstatedir/run/%name
%doc README* NEWS

%changelog
