%define _unpackaged_files_terminate_build 1
%def_enable snapshot

%define _name org.gnome.taquin
%define __name gnome-taquin
%define xdg_name org.gnome.Taquin
%define ver_major 3.38
%define _libexecdir %_prefix/libexec

Name: gnome-games-taquin
Version: %ver_major.1
Release: alt2

Summary: Gnome tiles game
Group: Games/Boards
License: GPLv3+
Url: https://wiki.gnome.org/Apps/Taquin

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%__name/%ver_major/%__name-%version.tar.xz
%else
Source: %__name-%version.tar
%endif

Provides:  %_name = %version-%release

%define glib_ver 2.40.0
%define gtk_ver 3.15.0

BuildRequires(pre): meson
BuildRequires: vala-tools
BuildRequires: yelp-tools libappstream-glib-devel desktop-file-utils
BuildRequires: libgio-devel >= %glib_ver libgtk+3-devel >= %gtk_ver librsvg-devel
BuildRequires: libgsound-devel

%description
Move tiles so that they reach their places.

%prep
%setup -n %__name-%version

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome %__name

%files -f %__name.lang
%_bindir/%__name
%_desktopdir/%xdg_name.desktop
%_datadir/%__name/
%_iconsdir/hicolor/*/*/%{xdg_name}*.svg
%_man6dir/%__name.*
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/metainfo/%xdg_name.appdata.xml
%doc AUTHORS NEWS COPYING*

%changelog
