%define _unpackaged_files_terminate_build 1

%define _name sudoku
%define xdg_name org.gnome.Sudoku
%define __name gnome-%_name
%define ver_major 49
%define beta %nil
%define _libexecdir %_prefix/libexec

%def_enable check

Name: gnome-games-%_name
Version: %ver_major.2
Release: alt1%beta

Summary: GNOME Sudoku game
Group: Games/Boards
License: GPL-3.0-or-later
Url: https://wiki.gnome.org/Apps/Sudoku

Vcs: https://gitlab.gnome.org/GNOME/gnome-sudoku.git

Source: ftp://ftp.gnome.org/pub/gnome/sources/%__name/%ver_major/%__name-%version.tar.xz

Provides:  %__name = %EVR

%define glib_ver 2.80.0
%define gtk_ver 4.18
%define adw_ver 1.7
%define qqwing_ver 1.3.4

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson vala-tools gcc-c++ blueprint-compiler
BuildRequires: yelp-tools
BuildRequires: gsettings-desktop-schemas-devel
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libgtk4-devel >= %gtk_ver
BuildRequires: libadwaita-devel >= %adw_ver
BuildRequires: libgee0.8-devel libjson-glib-devel
BuildRequires: libqqwing-devel >= %qqwing_ver
%{?_enable_check:BuildRequires: %_bindir/appstreamcli desktop-file-utils}

%description
Sudoku is a logic game with a Japanese name that has recently exploded
in popularity.

%prep
%setup -n %__name-%version

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome %__name

%check
%__meson_test

%files -f %__name.lang
%_bindir/%__name
%_desktopdir/%xdg_name.desktop
%_iconsdir/hicolor/*/apps/%{xdg_name}*.*
%_man6dir/%__name.*
%_datadir/dbus-1/services/%xdg_name.service
%config %_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/metainfo/%xdg_name.metainfo.xml

%changelog
