%def_disable snapshot
%define _unpackaged_files_terminate_build 1

%define _name hitori
%define xdg_name org.gnome.Hitori
%define ver_major 44
%define _libexecdir %_prefix/libexec

Name: gnome-games-%_name
Version: %ver_major.0
Release: alt1

Summary: GTK+ application to generate and let you play games of Hitori
Group: Games/Boards
License: GPLv3+
Url: https://wiki.gnome.org/Apps/Hitori

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz
%else
Source: %_name-%version.tar
%endif

Provides:  %_name = %version-%release

%define glib_ver 2.32.0
%define gtk_ver 3.22.0
%define cairo_ver 1.4

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson yelp-tools desktop-file-utils /usr/bin/appstream-util
BuildRequires: libgio-devel >= %glib_ver libgtk+3-devel >= %gtk_ver
BuildRequires: libcairo-devel >= %cairo_ver

%description
Hitori is a small logic puzzle in a similar vein to the more
popular Sudoku. In the game, the player starts with a square
board of numbers, and has to paint out cells until there are no
duplicate numbers in each row and column.

The following rules apply:
- There must only be one of each number in the unpainted cells in each
  row and column.
- No painted cell may be adjacent to another, vertically or horizontally.
- All the unpainted cells must be joined together vertically and
  horizontally in one group.

These are the only three rules of the game, and so there may well be
multiple solutions to a Hitori puzzle board.

%prep
%setup -n %_name-%version

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome %_name

%files -f %_name.lang
%attr(2711,root,games) %_bindir/%_name
%_desktopdir/%xdg_name.desktop
%_iconsdir/hicolor/*/apps/%{xdg_name}*.svg
%config %_datadir/glib-2.0/schemas/org.gnome.%_name.gschema.xml
%_datadir/metainfo/%xdg_name.appdata.xml

%changelog
