%define _unpackaged_files_terminate_build 1

%define _name chess
%define xdg_name org.gnome.Chess
%define __name gnome-%_name
%define ver_major 49
%define beta %nil
%define _libexecdir %_prefix/libexec

%def_enable check

Name: gnome-games-%_name
Version: %ver_major.2
Release: alt1%beta

Summary: A chess game for GNOME
Group: Games/Boards
License: GPL-3.0-or-later
Url: https://wiki.gnome.org/Apps/Chess

Vcs: https://gitlab.gnome.org/GNOME/gnome-chess.git

Source: ftp://ftp.gnome.org/pub/gnome/sources/%__name/%ver_major/%__name-%version%beta.tar.xz

Provides:  %__name = %version-%release
Obsoletes: gnome-games-glchess
Provides:  gnome-games-glchess = %version-%release
Requires: gnuchess >= 6.2.3

%define glib_ver 2.44
%define gtk_ver 4.10
%define rsvg_ver 2.46
%define vala_ver 0.50.0
%define adwaita_ver 1.5

BuildRequires(pre):rpm-macros-meson
BuildRequires: meson vala-tools >= %vala_ver
BuildRequires: yelp-tools
BuildRequires: libgio-devel >= %glib_ver libgtk4-devel >= %gtk_ver
BuildRequires: pkgconfig(libadwaita-1) >= %adwaita_ver
BuildRequires: librsvg-devel >= %rsvg_ver gsettings-desktop-schemas-devel
%{?_enable_check:BuildRequires:/usr/bin/appstreamcli desktop-file-utils}

%description
A chess game which supports several chess engines, with 2D and optionally
3D support if OpenGL is present.

%prep
%setup -n %__name-%version%beta

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome %__name

%check
%__meson_test

%files -f gnome-%_name.lang
%_bindir/%__name
%_desktopdir/%xdg_name.desktop
%_iconsdir/hicolor/*/apps/%{xdg_name}*.*
%_man6dir/%__name.*
%_datadir/dbus-1/services/%xdg_name.service
%config %_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%config(noreplace) %_sysconfdir/%__name/engines.conf
%_datadir/metainfo/%xdg_name.metainfo.xml

%changelog
