%define _unpackaged_files_terminate_build 1
%def_disable snapshot

%define _name aisleriot
%define ver_major 3.22
%define _libexecdir %_prefix/libexec

# fixed, kde, pysol, svg-rsvg, svg-qtsvg
# default: svg-rsvg
%define default_theme_format svg-rsvg
%def_enable theme_kde

Name: gnome-games-%_name
Version: %ver_major.35
Release: alt1

Summary: A collection of card games
Group: Games/Cards
License: GPL-3.0-or-later and GFDL-1.3-or-later
Url: https://wiki.gnome.org/Apps/Aisleriot

%if_disabled snapshot
Source: https://gitlab.gnome.org/GNOME/%_name/-/archive/%version/%_name-%version.tar.gz
%else
Source: %_name-%version.tar
%endif

Obsoletes: gnome-games-sol
Provides:  gnome-games-sol = %version-%release
Provides:  %_name = %version-%release

Requires: pysol-cardsets
%{?_enable_theme_kde:Requires: kde5-carddecks}

%define glib_ver 2.32.0
%define gtk_ver 3.18.0
# guile-3.0 also supported but /usr/bin/guile points to guile22
%define guile_ver 22

BuildRequires(pre): rpm-macros-meson
BuildRequires: /proc meson guile%guile_ver guile%guile_ver-devel
BuildRequires: desktop-file-utils yelp-tools libappstream-glib-devel libgio-devel >= %glib_ver
BuildRequires: libgtk+3-devel >= %gtk_ver librsvg-devel libcanberra-gtk3-devel
BuildRequires: libICE-devel libSM-devel
%{?_enable_theme_kde:BuildRequires: gcc-c++ qt5-base-devel qt5-svg-devel kde5-carddecks libxml2-devel}

%description
AisleRiot also known as Solitaire or sol is a collection of over 80 card games
which are easy to play with the aid of a mouse.

%prep
%setup -n %_name-%version

%build
%meson \
    -Ddefault_theme_format='svg-rsvg' \
    %{subst_enable_meson_bool theme_kde theme_kde} \
    %{?_enable_theme_kde:-Dtheme_kde_path=%_datadir/kf5/carddecks}
%nil
%meson_build

%install
%meson_install
%find_lang --with-gnome %_name

%files -f %_name.lang
%_bindir/sol
%_libdir/%_name/
%dir %_libexecdir/%_name
%_libexecdir/%_name/ar-cards-renderer
%_desktopdir/*.desktop
%_datadir/%_name/
%_iconsdir/hicolor/*/*/*.*
%_datadir/glib-2.0/schemas/org.gnome.Patience.WindowState.gschema.xml
%_datadir/metainfo/sol.metainfo.xml
%_man6dir/sol.*
%doc README* TODO COPYING.README

%exclude %_libdir/valgrind/aisleriot.supp

%changelog
