%def_disable snapshot

%define ver_major 3.58
%define _libexecdir %_prefix/libexec
%def_with compiz

Name: gnome-flashback
Version: %ver_major.0
Release: alt1

Summary: GNOME Flashback session
License: GPL-3.0
Group: Graphical desktop/GNOME
Url: https://wiki.gnome.org/Projects/GnomeFlashback

Vcs: https://gitlab.gnome.org/GNOME/gnome-flashback.git

%if_disabled snapshot
Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%define glib_ver 2.68.0
%define gtk_ver 3.24.6
%define desktop_ver 43
%define gsds_ver 3.32.0
%define compiz_ver 0.9.14.0
%define bt_api_ver 3.0
%define panel_ver %ver_major
%define applets_ver %ver_major
%define metacity_ver %ver_major

Requires(pre): xinitrc
Requires: wm-common-freedesktop
Requires: gnome-session >= 3.33.90 gnome-settings-daemon
Requires: gnome-panel >= %panel_ver gnome-applets >= %applets_ver metacity3.0 >= %metacity_ver
Requires: altlinux-freedesktop-menu-gnome3
Requires: dbus-tools-gui
Requires: gnome-filesystem
Requires: xdg-user-dirs
Requires: gnome-icon-theme gnome-icon-theme-symbolic
Requires: fonts-otf-abattis-cantarell gnome-backgrounds
Requires: gnome-keyring
Requires: gnome-control-center
Requires: nautilus
# since 3.18
Requires: polkit accountsservice
Requires: pinentry-gnome3
Requires: upower
Requires: bluez gnome-bluetooth%bt_api_ver
Requires: NetworkManager-applet-gtk
Requires: ibus xkeyboard-config
Requires: alacarte
Requires: tecla
# since 3.20
Conflicts: notification-daemon < 3.20

BuildRequires(pre): rpm-build-gnome rpm-build-xdg rpm-build-systemd rpm-build-xdg gnome-common
BuildRequires: libgnome-panel-devel >= %panel_ver
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: libgnome-desktop3-devel >= %desktop_ver
BuildRequires: gsettings-desktop-schemas-devel >= %gsds_ver
BuildRequires: libcanberra-gtk3-devel libpulseaudio-devel
BuildRequires: libXext-devel libXrandr-devel
BuildRequires: libupower-devel
# since 3.18
BuildRequires: libpolkit-devel pkgconfig(gnome-bluetooth-%bt_api_ver) libxcb-devel
BuildRequires: libibus-devel libxkbcommon-x11-devel libXi-devel
BuildRequires: libxkbfile-devel xkeyboard-config-devel
# since 3.36 (for screensaver)
BuildRequires: libpam-devel
BuildRequires: gdm-libs-devel libXxf86vm-devel
%{?_with_compiz:BuildRequires: libcompiz-devel >= %compiz_ver}

%description
GNOME Flashback provides unofficial session and helper application.

This session consists of gnome-applets, gnome-flashback, gnome-panel and
metacity. And all other modules that are used in official GNOME session.

Helper application main job is to provide all features that is need for
our session, but has been removed from GNOME and/or moved to mutter or
gnome-shell.

NOTE: This session is not supported by GNOME in any way!

%package session-compiz
Summary: A Compiz session for the GNOME Flashback
Group: Graphical desktop/GNOME
BuildArch: noarch
Requires: %name = %version-%release
Requires: compiz

%description session-compiz
This package permits to log into GNOME Flashback with Compiz.

%prep
%setup
# remove pre-generated
find ./ -name "*enum-types.[c,h]" -print0 | xargs -r0 rm -f --

%build
%autoreconf
%configure \
    --disable-static \
    --disable-schemas-compile \
    %{?_with_compiz:--with-compiz-session}
%nil
%make_build

%install
%makeinstall_std

# link to our gnome3 menus
ln -sf gnome-applications.menu %buildroot/%_xdgmenusdir/%name-applications.menu

%find_lang --with-gnome --output=%name.lang %name

%check
%make check

%files -f %name.lang
%_xdgconfigdir/autostart/%name-geoclue-demo-agent.desktop
%_bindir/%name
%_libdir/gnome-panel/modules/system_indicators.so
%exclude %_libdir/gnome-panel/modules/system_indicators.la
%_libexecdir/%name-metacity
%_libexecdir/%name-clipboard
%_libexecdir/%name-media-keys
%_libexecdir/%name-idle-monitor
%_libexecdir/%name-polkit
%_desktopdir/%name.desktop
%_datadir/gnome-panel/layouts/%name.layout
%_datadir/desktop-directories/X-GNOME-Flashback-Settings-System.directory
%_datadir/desktop-directories/X-GNOME-Flashback-Science.directory
%_datadir/desktop-directories/X-GNOME-Flashback-Settings.directory
%_datadir/gnome-session/sessions/%name-metacity.session
%_datadir/glib-2.0/schemas/org.gnome.%name.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.%name.desktop.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.%name.desktop.background.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.%name.desktop.enums.xml
%_datadir/glib-2.0/schemas/org.gnome.%name.desktop.icons.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.%name.keybindings.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.%name.notifications.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.%name.system-indicators.input-sources.gschema.xml
%_datadir/glib-2.0/schemas/00_gnome-flashback.gschema.override
%_datadir/gnome-control-center/keybindings/50-gnome-flashback-screenshots.xml
%_xdgmenusdir/%name-applications.menu
%_datadir/xsessions/%name-metacity.desktop
%_xdgconfigdir/autostart/%name-nm-applet.desktop
%_userunitdir/%name.service
%_userunitdir/%name.target
%_userunitdir/gnome-session@%name-metacity.target.d/session.conf
%_userunitdir/%name-clipboard.service
%_userunitdir/%name-idle-monitor.service
%_userunitdir/%name-media-keys.service
%_userunitdir/%name-polkit.service
%_userunitdir/gnome-session-x11@%name-compiz.target
%_userunitdir/gnome-session-x11@%name-metacity.target
%_userunitdir/gnome-session@%name-compiz.target.d/compiz.conf
%_userunitdir/gnome-session@%name-metacity.target.d/metacity.conf
%doc AUTHORS NEWS README*

%if_with compiz
%files session-compiz
%_libexecdir/%name-compiz
%_userunitdir/gnome-session@%name-compiz.target.d/session.conf
%_datadir/gnome-session/sessions/%name-compiz.session
%_datadir/xsessions/%name-compiz.desktop
%_sysconfdir/compizconfig/%name.conf
%_sysconfdir/compizconfig/%name.ini
%endif


%changelog
