%define ver_major 0.20

%undefine _configure_target

Name: gnome-doc-utils
Version: %ver_major.10
Release: alt3

Summary: Documentation utilities for GNOME
Group: Development/Other
License: %gpl2plus
Url: http://www.gnome.org/

Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
Source1: scrollkeeper-omf.dtd
# GNOME bug #524207
Patch1: gnome-doc-utils-0.14.0-package.patch
Patch2: gnome-doc-utils-fig-path.patch
# https://src.fedoraproject.org/rpms/gnome-doc-utils/blob/rawhide/f/gnome-doc-utils-0.20.10-python3.patch
Patch3: gnome-doc-utils-0.20.10-fc-python3.patch

%define pkgdocdir %_docdir/%name-%version

%define libxml_version 2.6.12
%define libxslt_version 1.1.8

Requires: %name-xslt = %version-%release
Requires: librarian

%add_python3_path %python3_sitelibdir/xml2po

BuildArch: noarch

BuildRequires(pre): rpm-build-python3 rpm-build-licenses rpm-build-gnome
BuildRequires: intltool
BuildRequires: libxml2-devel >= %libxml_version
BuildRequires: libxslt-devel >= %libxslt_version
BuildRequires: python3-devel python3-module-libxml2
BuildRequires: db2latex-xsl docbook-dtds librarian xsltproc

%description
gnome-doc-utils is a collection of documentation utilities for the Gnome
project. It contains the DocBook XSLT stylesheets that were once
distributed with Yelp.

%package xslt
Summary: XSLT stylesheets for %name
Group: Development/Other
License: %lgpl2plus

%description xslt
XSLT stylesheets from the gnome-doc-utils collection.

%prep
%setup
cp %SOURCE1 doc/

%if 0
%_bindir/xmlcatalog --create --noout catalog
%_bindir/xmlcatalog --noout --add "public" \
"-//OMF//DTD Scrollkeeper OMF Variant V1.0//EN" \
"doc/scrollkeeper-omf.dtd" catalog
export SGML_CATALOG_FILES=catalog
%endif

%patch1 -p1 -b .package
%patch2 -p1 -b .fig
%patch3 -p1 -b .python3

# Update URLs of external entities to fix build in isolated network environment.
find -type f -print0 |
	xargs -r0 grep -lZ "'http://[^']*/scrollkeeper-omf[.]dtd'" |
	xargs -r0 sed -i "s|'http://[^']*/scrollkeeper-omf[.]dtd'|'/usr/share/xml/scrollkeeper/dtds/scrollkeeper-omf.dtd'|" --

%build
export am_cv_python_pythondir=%python3_sitelibdir
%configure --disable-scrollkeeper \
    PYTHON=%__python3
%nil
# SMP-incompatible build
%make

%check
%make check

%install
%makeinstall_std

%find_lang --with-gnome --output=%name.lang gnome-doc-make gnome-doc-xslt gnome-doc-mallard-spec gnome-doc-utils

install -d -m755 %buildroot%pkgdocdir
install -p -m644 AUTHORS README NEWS COPYING %buildroot%pkgdocdir/
ln -s %_licensedir/GPL-2 %buildroot%pkgdocdir/COPYING.GPL
ln -s %_licensedir/LGPL-2.1 %buildroot%pkgdocdir/COPYING.LGPL

%files -f %name.lang
%_bindir/*
%_datadir/pkgconfig/*
%_datadir/aclocal/*
%_datadir/%name
%dir %_datadir/xml/mallard/1.0/
%_datadir/xml/mallard/1.0/*
%_man1dir/*
#python
%python3_sitelibdir/xml2po/
%dir %pkgdocdir
%pkgdocdir/AUTHORS
%pkgdocdir/COPYING
%pkgdocdir/COPYING.GPL
%pkgdocdir/NEWS
%pkgdocdir/README

%files xslt
%pkgdocdir/COPYING.LGPL
%_datadir/xml/gnome

%changelog
