%define _unpackaged_files_terminate_build 1

%define _name baobab
%define xdg_name org.gnome.baobab
%define ver_major 49
%define beta %nil
%set_typelibdir %_libdir/%_name/girepository-1.0

Name: gnome-disk-usage
Version: %ver_major.0
Release: alt1%beta

Summary: The GNOME disk usage analyser.
License: GPL-2.0-or-later
Group: Graphical desktop/GNOME
Url: https://wiki.gnome.org/Apps/DiskUsageAnalyzer

Vcs: https://gitlab.gnome.org/GNOME/baobab.git

Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version%beta.tar.xz

Provides: gnome-disk-usage-analyser = %EVR
Provides: baobab = %EVR

%define gtk4_ver 4.16.0
%define vala_ver 0.23.3
%define adwaita_ver 1.6

BuildRequires(pre): rpm-macros-meson rpm-build-gir
BuildRequires: meson vala-tools >= %vala_ver
BuildRequires: yelp-tools xmllint
BuildRequires: libgtk4-devel >= %gtk4_ver
BuildRequires: pkgconfig(libadwaita-1) >= %adwaita_ver
BuildRequires: gobject-introspection-devel libgtk4-gir-devel
BuildRequires: /usr/bin/appstreamcli desktop-file-utils

%description
Baobab is a graphical tool to analyse disk usage in local and remote
filesystems.

%prep
%setup -n %_name-%version%beta

%build
%meson
%meson_build

%install
%meson_install

pushd %buildroot%_bindir
ln -s baobab gnome-disk-usage
popd

%find_lang --with-gnome %_name

%files -f %_name.lang
%_bindir/%_name
%_bindir/gnome-disk-usage
%_desktopdir/%xdg_name.desktop
%_iconsdir/hicolor/*/apps/%{xdg_name}*.svg
%_man1dir/%_name.1.*
%_datadir/dbus-1/services/%xdg_name.service
%config %_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/metainfo/%xdg_name.metainfo.xml
%doc README* NEWS

%changelog
